/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.data.LevelLoader;
import net.levelz.init.ConfigInit;
import net.levelz.network.PlayerStatsServerPacket;
import net.levelz.stats.PlayerStatsManager;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_746;

public class PlayerStatsClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.XP_PACKET, (client, handler, buf, sender) -> {
            if (client.field_1724 != null) {
                PlayerStatsClientPacket.executeXPPacket((class_1657)client.field_1724, buf);
            } else {
                class_2540 newBuffer = new class_2540(Unpooled.buffer());
                newBuffer.writeFloat(buf.readFloat());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                client.execute(() -> PlayerStatsClientPacket.executeXPPacket((class_1657)client.field_1724, newBuffer));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.LEVEL_PACKET, (client, handler, buf, sender) -> {
            if (client.field_1724 != null) {
                PlayerStatsClientPacket.executeLevelPacket((class_1657)client.field_1724, buf);
            } else {
                class_2540 newBuffer = new class_2540(Unpooled.buffer());
                newBuffer.writeFloat(buf.readFloat());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                newBuffer.writeInt(buf.readInt());
                client.execute(() -> PlayerStatsClientPacket.executeLevelPacket((class_1657)client.field_1724, newBuffer));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.LIST_PACKET, (client, handler, buf, sender) -> {
            if (client.field_1724 != null) {
                PlayerStatsClientPacket.executeListPacket(buf, client.field_1724);
            } else {
                class_2540 newBuffer = new class_2540(Unpooled.buffer());
                while (buf.isReadable()) {
                    newBuffer.method_10814(buf.method_19772());
                }
                client.execute(() -> PlayerStatsClientPacket.executeListPacket(newBuffer, client.field_1724));
            }
        });
    }

    public static void writeC2SIncreaseLevelPacket(PlayerStatsManager playerStatsManager, String string) {
        playerStatsManager.setLevel(string, playerStatsManager.getLevel(string) + 1);
        playerStatsManager.setLevel("points", playerStatsManager.getLevel("points") - 1);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(string);
        buf.writeInt(playerStatsManager.getLevel(string));
        class_2817 packet = new class_2817(PlayerStatsServerPacket.STATS_INCREASE_PACKET, buf);
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    private static void executeXPPacket(class_1657 player, class_2540 buf) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager(player);
        playerStatsManager.levelProgress = buf.readFloat();
        playerStatsManager.totalLevelExperience = buf.readInt();
        playerStatsManager.setLevel("level", buf.readInt());
    }

    private static void executeLevelPacket(class_1657 player, class_2540 buf) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager(player);
        playerStatsManager.levelProgress = buf.readFloat();
        playerStatsManager.totalLevelExperience = buf.readInt();
        playerStatsManager.setLevel("level", buf.readInt());
        playerStatsManager.setLevel("points", buf.readInt());
        playerStatsManager.setLevel("health", buf.readInt());
        playerStatsManager.setLevel("strength", buf.readInt());
        playerStatsManager.setLevel("agility", buf.readInt());
        playerStatsManager.setLevel("defense", buf.readInt());
        playerStatsManager.setLevel("stamina", buf.readInt());
        playerStatsManager.setLevel("luck", buf.readInt());
        playerStatsManager.setLevel("archery", buf.readInt());
        playerStatsManager.setLevel("trade", buf.readInt());
        playerStatsManager.setLevel("smithing", buf.readInt());
        playerStatsManager.setLevel("mining", buf.readInt());
        playerStatsManager.setLevel("farming", buf.readInt());
        playerStatsManager.setLevel("alchemy", buf.readInt());
        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
    }

    private static void executeListPacket(class_2540 buf, class_746 player) {
        LevelLoader.clearEveryList();
        ArrayList<String> list = new ArrayList<String>();
        while (buf.isReadable()) {
            list.add(buf.method_19772());
        }
        for (int i = 0; i < list.size(); ++i) {
            int u;
            String listName = ((String)list.get(i)).toString();
            if (LevelLists.getListNames().contains(listName)) {
                int count = 2;
                int negativeCount = -2;
                if (listName.equals("minecraft:armor") || listName.equals("minecraft:tool") || listName.equals("minecraft:hoe") || listName.equals("minecraft:sword") || listName.equals("minecraft:axe")) {
                    --negativeCount;
                }
                if (listName.equals("minecraft:enchanting")) {
                    count = 5;
                }
                for (int u2 = negativeCount; u2 < count; ++u2) {
                    PlayerStatsClientPacket.addToList(listName, (String)list.get(i + u2));
                }
                continue;
            }
            if (listName.equals("mining:level")) {
                ArrayList<Integer> blockList = new ArrayList<Integer>();
                LevelLists.miningLevelList.add(Integer.parseInt((String)list.get(i + 1)));
                for (u = i + 2; u < list.size() && !((String)list.get(u)).equals("mining:level") && !((String)list.get(u)).equals("brewing:level"); ++u) {
                    blockList.add(Integer.parseInt((String)list.get(u)));
                }
                LevelLists.miningBlockList.add(blockList);
                continue;
            }
            if (!listName.equals("brewing:level")) continue;
            ArrayList<Integer> itemList = new ArrayList<Integer>();
            LevelLists.brewingLevelList.add(Integer.parseInt((String)list.get(i + 1)));
            for (u = i + 2; u < list.size() && !((String)list.get(u)).equals("brewing:level"); ++u) {
                itemList.add(Integer.parseInt((String)list.get(u)));
            }
            LevelLists.brewingItemList.add(itemList);
        }
        LevelLoader.addAllInOneList();
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager((class_1657)player);
        player.method_5996(class_5134.field_23716).method_6192(ConfigInit.CONFIG.healthBase + (double)playerStatsManager.getLevel("health") * ConfigInit.CONFIG.healthBonus);
        player.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase + (double)playerStatsManager.getLevel("agility") * ConfigInit.CONFIG.movementBonus);
        player.method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase + (double)playerStatsManager.getLevel("strength") * ConfigInit.CONFIG.attackBonus);
        player.method_5996(class_5134.field_23724).method_6192(ConfigInit.CONFIG.defenseBase + (double)playerStatsManager.getLevel("defense") * ConfigInit.CONFIG.defenseBonus);
        player.method_5996(class_5134.field_23726).method_6192(ConfigInit.CONFIG.luckBase + (double)playerStatsManager.getLevel("luck") * ConfigInit.CONFIG.luckBonus);
        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
    }

    private static void addToList(String listName, String object) {
        if (object.matches("-?(0|[1-9]\\d*)")) {
            LevelLists.getList(listName).add(Integer.parseInt(object));
        } else if (object.equals("false") || object.equals("true")) {
            LevelLists.getList(listName).add(Boolean.parseBoolean(object));
        } else {
            LevelLists.getList(listName).add(object);
        }
    }
}

