/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.stats.PlayerStatsManager;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class PlayerStatsServerPacket {
    public static final class_2960 STATS_INCREASE_PACKET = new class_2960("levelz", "player_increase_stats");
    public static final class_2960 XP_PACKET = new class_2960("levelz", "player_level_xp");
    public static final class_2960 LEVEL_PACKET = new class_2960("levelz", "player_level_stats");
    public static final class_2960 LIST_PACKET = new class_2960("levelz", "unlocking_list");

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)STATS_INCREASE_PACKET, (server, player, handler, buffer, sender) -> {
            if (player != null) {
                String stat = buffer.method_19772();
                PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager((class_1657)player);
                playerStatsManager.setLevel(stat, buffer.readInt());
                playerStatsManager.setLevel("points", playerStatsManager.getLevel("points") - 1);
                if (stat.equals("health")) {
                    player.method_5996(class_5134.field_23716).method_6192(player.method_26826(class_5134.field_23716) + 1.0);
                    player.method_6033(player.method_6032() + 1.0f);
                } else if (stat.equals("strength")) {
                    player.method_5996(class_5134.field_23721).method_6192(player.method_26826(class_5134.field_23721) + 0.2);
                } else if (stat.equals("agility")) {
                    player.method_5996(class_5134.field_23719).method_6192(player.method_26826(class_5134.field_23719) + 0.001);
                } else if (stat.equals("defense")) {
                    player.method_5996(class_5134.field_23724).method_6192(player.method_26826(class_5134.field_23724) + 0.2);
                } else if (stat.equals("luck")) {
                    player.method_5996(class_5134.field_23726).method_6192(player.method_26826(class_5134.field_23724) + 0.05);
                } else if (stat.equals("mining")) {
                    PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
                } else if (stat.equals("alchemy")) {
                    PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
                }
            }
        });
    }

    public static void writeS2CXPPacket(PlayerStatsManager playerStatsManager, class_3222 serverPlayerEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(playerStatsManager.levelProgress);
        buf.writeInt(playerStatsManager.totalLevelExperience);
        buf.writeInt(playerStatsManager.getLevel("level"));
        class_2658 packet = new class_2658(XP_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CSkillPacket(PlayerStatsManager playerStatsManager, class_3222 serverPlayerEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(playerStatsManager.levelProgress);
        buf.writeInt(playerStatsManager.totalLevelExperience);
        buf.writeInt(playerStatsManager.getLevel("level"));
        buf.writeInt(playerStatsManager.getLevel("points"));
        buf.writeInt(playerStatsManager.getLevel("health"));
        buf.writeInt(playerStatsManager.getLevel("strength"));
        buf.writeInt(playerStatsManager.getLevel("agility"));
        buf.writeInt(playerStatsManager.getLevel("defense"));
        buf.writeInt(playerStatsManager.getLevel("stamina"));
        buf.writeInt(playerStatsManager.getLevel("luck"));
        buf.writeInt(playerStatsManager.getLevel("archery"));
        buf.writeInt(playerStatsManager.getLevel("trade"));
        buf.writeInt(playerStatsManager.getLevel("smithing"));
        buf.writeInt(playerStatsManager.getLevel("mining"));
        buf.writeInt(playerStatsManager.getLevel("farming"));
        buf.writeInt(playerStatsManager.getLevel("alchemy"));
        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
        class_2658 packet = new class_2658(LEVEL_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void syncLockedBlockList(PlayerStatsManager playerStatsManager) {
        playerStatsManager.lockedBlockIds.clear();
        for (int i = 0; i < LevelLists.miningLevelList.size(); ++i) {
            if (LevelLists.miningLevelList.get(i) <= playerStatsManager.getLevel("mining")) continue;
            for (int u = 0; u < LevelLists.miningBlockList.get(i).size(); ++u) {
                if (playerStatsManager.lockedBlockIds.contains(LevelLists.miningBlockList.get(i).get(u))) continue;
                playerStatsManager.lockedBlockIds.add(LevelLists.miningBlockList.get(i).get(u));
            }
        }
    }

    public static void syncLockedBrewingItemList(PlayerStatsManager playerStatsManager) {
        playerStatsManager.lockedbrewingItemIds.clear();
        for (int i = 0; i < LevelLists.brewingLevelList.size(); ++i) {
            if (LevelLists.brewingLevelList.get(i) <= playerStatsManager.getLevel("alchemy")) continue;
            for (int u = 0; u < LevelLists.brewingItemList.get(i).size(); ++u) {
                if (playerStatsManager.lockedbrewingItemIds.contains(LevelLists.brewingItemList.get(i).get(u))) continue;
                playerStatsManager.lockedbrewingItemIds.add(LevelLists.brewingItemList.get(i).get(u));
            }
        }
    }

    public static void writeS2CListPacket(class_3222 serverPlayerEntity) {
        int k;
        class_2540 buf = new class_2540(Unpooled.buffer());
        for (int i = 0; i < LevelLists.getListNames().size(); ++i) {
            String listName = LevelLists.getListNames().get(i);
            ArrayList<Object> list = LevelLists.getList(listName);
            for (int u = 0; u < list.size(); ++u) {
                buf.method_10814(list.get(u).toString());
            }
        }
        for (k = 0; k < LevelLists.miningLevelList.size(); ++k) {
            buf.method_10814("mining:level");
            buf.method_10814(LevelLists.miningLevelList.get(k).toString());
            for (int u = 0; u < LevelLists.miningBlockList.get(k).size(); ++u) {
                buf.method_10814(LevelLists.miningBlockList.get(k).get(u).toString());
            }
        }
        for (k = 0; k < LevelLists.brewingLevelList.size(); ++k) {
            buf.method_10814("brewing:level");
            buf.method_10814(LevelLists.brewingLevelList.get(k).toString());
            for (int u = 0; u < LevelLists.brewingItemList.get(k).size(); ++u) {
                buf.method_10814(LevelLists.brewingItemList.get(k).get(u).toString());
            }
        }
        class_2658 packet = new class_2658(LIST_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }
}

