/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.stats;

import java.util.ArrayList;
import java.util.List;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.init.ConfigInit;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class PlayerStatsManager {
    public int overallLevel;
    public float levelProgress;
    public int totalLevelExperience;
    private int healthLevel;
    private int strengthLevel;
    private int agilityLevel;
    private int defenseLevel;
    private int staminaLevel;
    private int luckLevel;
    private int archeryLevel;
    private int tradeLevel;
    private int smithingLevel;
    private int miningLevel;
    private int farmingLevel;
    private int alchemyLevel;
    private int skillPoints;
    public List<Integer> lockedBlockIds = new ArrayList<Integer>();
    public List<Integer> lockedbrewingItemIds = new ArrayList<Integer>();

    public void readNbt(class_2487 tag) {
        if (tag.method_10573("HealthLevel", 99)) {
            this.overallLevel = tag.method_10550("Level");
            this.levelProgress = tag.method_10583("LevelProgress");
            this.totalLevelExperience = tag.method_10550("TotalLevelExperience");
            this.skillPoints = tag.method_10550("SkillPoints");
            this.healthLevel = tag.method_10550("HealthLevel");
            this.strengthLevel = tag.method_10550("StrengthLevel");
            this.agilityLevel = tag.method_10550("AgilityLevel");
            this.defenseLevel = tag.method_10550("DefenseLevel");
            this.staminaLevel = tag.method_10550("StaminaLevel");
            this.luckLevel = tag.method_10550("LuckLevel");
            this.archeryLevel = tag.method_10550("ArcheryLevel");
            this.tradeLevel = tag.method_10550("TradeLevel");
            this.smithingLevel = tag.method_10550("SmithingLevel");
            this.miningLevel = tag.method_10550("MiningLevel");
            this.farmingLevel = tag.method_10550("FarmingLevel");
            this.alchemyLevel = tag.method_10550("AlchemyLevel");
        }
    }

    public void writeNbt(class_2487 tag) {
        tag.method_10569("Level", this.overallLevel);
        tag.method_10548("LevelProgress", this.levelProgress);
        tag.method_10569("TotalLevelExperience", this.totalLevelExperience);
        tag.method_10569("SkillPoints", this.skillPoints);
        tag.method_10569("HealthLevel", this.healthLevel);
        tag.method_10569("StrengthLevel", this.strengthLevel);
        tag.method_10569("AgilityLevel", this.agilityLevel);
        tag.method_10569("DefenseLevel", this.defenseLevel);
        tag.method_10569("StaminaLevel", this.staminaLevel);
        tag.method_10569("LuckLevel", this.luckLevel);
        tag.method_10569("ArcheryLevel", this.archeryLevel);
        tag.method_10569("TradeLevel", this.tradeLevel);
        tag.method_10569("SmithingLevel", this.smithingLevel);
        tag.method_10569("MiningLevel", this.miningLevel);
        tag.method_10569("FarmingLevel", this.farmingLevel);
        tag.method_10569("AlchemyLevel", this.alchemyLevel);
    }

    public void setLevel(String string, int level) {
        switch (string) {
            case "level": {
                this.overallLevel = level;
                break;
            }
            case "health": {
                this.healthLevel = level;
                break;
            }
            case "strength": {
                this.strengthLevel = level;
                break;
            }
            case "agility": {
                this.agilityLevel = level;
                break;
            }
            case "defense": {
                this.defenseLevel = level;
                break;
            }
            case "stamina": {
                this.staminaLevel = level;
                break;
            }
            case "luck": {
                this.luckLevel = level;
                break;
            }
            case "archery": {
                this.archeryLevel = level;
                break;
            }
            case "trade": {
                this.tradeLevel = level;
                break;
            }
            case "smithing": {
                this.smithingLevel = level;
                break;
            }
            case "mining": {
                this.miningLevel = level;
                break;
            }
            case "farming": {
                this.farmingLevel = level;
                break;
            }
            case "alchemy": {
                this.alchemyLevel = level;
                break;
            }
            case "points": {
                this.skillPoints = level;
                break;
            }
        }
    }

    public int getLevel(String string) {
        switch (string) {
            case "level": {
                return this.overallLevel;
            }
            case "health": {
                return this.healthLevel;
            }
            case "strength": {
                return this.strengthLevel;
            }
            case "agility": {
                return this.agilityLevel;
            }
            case "defense": {
                return this.defenseLevel;
            }
            case "stamina": {
                return this.staminaLevel;
            }
            case "luck": {
                return this.luckLevel;
            }
            case "archery": {
                return this.archeryLevel;
            }
            case "trade": {
                return this.tradeLevel;
            }
            case "smithing": {
                return this.smithingLevel;
            }
            case "mining": {
                return this.miningLevel;
            }
            case "farming": {
                return this.farmingLevel;
            }
            case "alchemy": {
                return this.alchemyLevel;
            }
            case "points": {
                return this.skillPoints;
            }
        }
        return 0;
    }

    public void addExperienceLevels(int levels) {
        this.overallLevel += levels;
        ++this.skillPoints;
        if (this.overallLevel < 0) {
            this.overallLevel = 0;
            this.levelProgress = 0.0f;
            this.totalLevelExperience = 0;
        }
    }

    public int getNextLevelExperience() {
        return (int)((float)ConfigInit.CONFIG.xpBaseCost + ConfigInit.CONFIG.xpCostMultiplicator * (float)class_3532.method_34954((int)this.overallLevel));
    }

    public static boolean playerLevelisHighEnough(class_1657 playerEntity, List<Object> list, String string, boolean creativeRequired) {
        if (!playerEntity.method_7337() || !creativeRequired) {
            PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager(playerEntity);
            int playerLevel = 0;
            int maxLevel = ConfigInit.CONFIG.maxLevel;
            if (string != null) {
                if (list.contains(string)) {
                    playerLevel = playerStatsManager.getLevel(list.get(list.indexOf(string) + 1).toString());
                    if (playerLevel < maxLevel && playerLevel < (Integer)list.get(list.indexOf(string) + 2)) {
                        return false;
                    }
                } else {
                    System.out.println("Couldn't find " + string + " list");
                }
            } else {
                playerLevel = playerStatsManager.getLevel(list.get(0).toString());
                if (playerLevel < maxLevel && playerLevel < (Integer)list.get(1)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean listContainsItemOrBlock(class_1657 playerEntity, int id, boolean isBlock) {
        int playerBrewingLevel;
        int playerMiningLevel;
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager(playerEntity);
        return isBlock ? (playerMiningLevel = playerStatsManager.getLevel("mining")) < ConfigInit.CONFIG.maxLevel && playerStatsManager.lockedBlockIds.contains(id) : (playerBrewingLevel = playerStatsManager.getLevel("alchemy")) < ConfigInit.CONFIG.maxLevel && playerStatsManager.lockedbrewingItemIds.contains(id);
    }

    public static int getUnlockLevel(int id, boolean isBlock) {
        if (isBlock) {
            for (int i = 0; i < LevelLists.miningBlockList.size(); ++i) {
                if (!LevelLists.miningBlockList.get(i).contains(id)) continue;
                return LevelLists.miningLevelList.get(i);
            }
            return 0;
        }
        for (int i = 0; i < LevelLists.brewingItemList.size(); ++i) {
            if (!LevelLists.brewingItemList.get(i).contains(id)) continue;
            return LevelLists.brewingLevelList.get(i);
        }
        return 0;
    }
}

