/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.Sounds;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3532;

public abstract class GunItem
extends class_1792 {
    public static final int LOADING_STAGE_1 = 5;
    public static final int LOADING_STAGE_2 = 10;
    public static final int LOADING_STAGE_3 = 20;
    public static final int RELOAD_DURATION = 30;
    public static class_1799 activeMainHandStack;
    public static class_1799 activeOffhandStack;

    public GunItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public abstract float bulletStdDev();

    public abstract float bulletSpeed();

    public abstract float damageMultiplierMin();

    public abstract float damageMultiplierMax();

    public abstract class_3414 fireSound();

    public abstract boolean twoHanded();

    public abstract boolean ignoreInvulnerableTime();

    public boolean canUseFrom(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return true;
        }
        if (this.twoHanded()) {
            return false;
        }
        class_1799 mainHandStack = player.method_5998(class_1268.field_5808);
        if (!mainHandStack.method_7960() && mainHandStack.method_7909() instanceof GunItem) {
            return !((GunItem)mainHandStack.method_7909()).twoHanded();
        }
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 player, class_1268 hand) {
        GunItem offhandGun;
        class_1799 offhandStack;
        if (!this.canUseFrom(player, hand)) {
            return super.method_7836(worldIn, player, hand);
        }
        class_1799 stack = player.method_5998(hand);
        boolean creative = player.method_31549().field_7477;
        if (player.method_5777(class_3486.field_15517) && !creative) {
            return class_1271.method_22431((Object)stack);
        }
        if (hand == class_1268.field_5808 && !this.twoHanded() && GunItem.isLoaded(stack) && !(offhandStack = player.method_5998(class_1268.field_5810)).method_7960() && offhandStack.method_7909() instanceof GunItem && !(offhandGun = (GunItem)offhandStack.method_7909()).twoHanded() && GunItem.isLoaded(offhandStack)) {
            return class_1271.method_22430((Object)stack);
        }
        boolean haveAmmo = !GunItem.findAmmo(player).method_7960() || creative;
        boolean loaded = GunItem.isLoaded(stack);
        if (loaded) {
            if (!worldIn.field_9236) {
                class_243 front = class_243.method_1030((float)player.method_36455(), (float)player.method_36454());
                class_1306 arm = hand == class_1268.field_5808 ? player.method_6068() : player.method_6068().method_5928();
                boolean isRightHand = arm == class_1306.field_6183;
                class_243 side = class_243.method_1030((float)0.0f, (float)(player.method_36454() + (float)(isRightHand ? 90 : -90)));
                class_243 down = class_243.method_1030((float)(player.method_36455() + 90.0f), (float)player.method_36454());
                this.fire((class_1309)player, front, side.method_1019(down).method_1021(0.15));
            }
            player.method_5783(this.fireSound(), 3.5f, 1.0f);
            GunItem.setLoaded(stack, false);
            stack.method_7956(1, (class_1309)player, entity -> entity.method_20236(hand));
            if (worldIn.field_9236) {
                GunItem.setActiveStack(hand, stack);
            }
            return class_1271.method_22428((Object)stack);
        }
        if (haveAmmo) {
            GunItem.setLoadingStage(stack, 1);
            player.method_6019(hand);
            if (worldIn.field_9236) {
                GunItem.setActiveStack(hand, stack);
            }
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        GunItem.setLoadingStage(stack, 0);
    }

    public void method_7852(class_1937 world, class_1309 entity, class_1799 stack, int timeLeft) {
        int usingDuration = this.method_7881(stack) - timeLeft;
        int loadingStage = GunItem.getLoadingStage(stack);
        if (loadingStage == 1 && usingDuration >= 5) {
            entity.method_5783(Sounds.MUSKET_LOAD_0, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 2);
        } else if (loadingStage == 2 && usingDuration >= 10) {
            entity.method_5783(Sounds.MUSKET_LOAD_1, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 3);
        } else if (loadingStage == 3 && usingDuration >= 20) {
            entity.method_5783(Sounds.MUSKET_LOAD_2, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 4);
        }
        if (world.field_9236 && entity instanceof class_1657) {
            GunItem.setActiveStack(entity.method_6058(), stack);
            return;
        }
        if (usingDuration >= 30 && !GunItem.isLoaded(stack)) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (!player.method_31549().field_7477) {
                    class_1799 ammoStack = GunItem.findAmmo(player);
                    if (ammoStack.method_7960()) {
                        return;
                    }
                    ammoStack.method_7934(1);
                    if (ammoStack.method_7960()) {
                        player.method_31548().method_7378(ammoStack);
                    }
                }
            }
            world.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), Sounds.MUSKET_READY, entity.method_5634(), 0.8f, 1.0f);
            GunItem.setLoaded(stack, true);
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 enemy, class_1309 entityIn) {
        stack.method_7956(1, entityIn, entity -> entity.method_20235(class_1304.field_6173));
        return false;
    }

    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 state, class_2338 pos, class_1309 entityIn) {
        if (state.method_26214((class_1922)worldIn, pos) != 0.0f) {
            stack.method_7956(1, entityIn, entity -> entity.method_20235(class_1304.field_6173));
        }
        return false;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void fire(class_1309 shooter, class_243 direction) {
        this.fire(shooter, direction, class_243.field_1353);
    }

    public void fire(class_1309 shooter, class_243 direction, class_243 smokeOriginOffset) {
        class_243 n2;
        class_243 n1;
        Random random = shooter.method_6051();
        class_1937 level = shooter.field_6002;
        float angle = (float)Math.PI * 2 * random.nextFloat();
        float gaussian = Math.abs((float)random.nextGaussian());
        if (gaussian > 4.0f) {
            gaussian = 4.0f;
        }
        float spread = this.bulletStdDev() * gaussian;
        if (Math.abs(direction.field_1352) < 1.0E-5 && Math.abs(direction.field_1350) < 1.0E-5) {
            n1 = new class_243(1.0, 0.0, 0.0);
            n2 = new class_243(0.0, 0.0, 1.0);
        } else {
            n1 = new class_243(-direction.field_1350, 0.0, direction.field_1352).method_1029();
            n2 = direction.method_1036(n1);
        }
        class_243 motion = direction.method_1021((double)class_3532.method_15362((float)spread)).method_1019(n1.method_1021((double)(class_3532.method_15374((float)spread) * class_3532.method_15374((float)angle)))).method_1019(n2.method_1021((double)(class_3532.method_15374((float)spread) * class_3532.method_15362((float)angle)))).method_1021((double)this.bulletSpeed());
        class_243 origin = new class_243(shooter.method_23317(), shooter.method_23320(), shooter.method_23321());
        BulletEntity bullet = new BulletEntity(level);
        bullet.method_7432((class_1297)shooter);
        bullet.method_33574(origin);
        bullet.setInitialSpeed(this.bulletSpeed());
        bullet.method_18799(motion);
        float t = random.nextFloat();
        bullet.damageMultiplier = t * this.damageMultiplierMin() + (1.0f - t) * this.damageMultiplierMax();
        bullet.ignoreInvulnerableTime = this.ignoreInvulnerableTime();
        level.method_8649((class_1297)bullet);
        MusketMod.sendSmokeEffect(shooter, origin.method_1019(smokeOriginOffset), direction);
    }

    public static void fireParticles(class_1937 world, class_243 origin, class_243 direction) {
        Random random = world.method_8409();
        for (int i = 0; i != 10; ++i) {
            double t = Math.pow(random.nextFloat(), 1.5);
            class_243 p = origin.method_1019(direction.method_1021(1.25 + t));
            p = p.method_1019(new class_243((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5).method_1021(0.1));
            class_243 v = direction.method_1021(0.1 * (1.0 - t));
            world.method_8406((class_2394)class_2398.field_11203, p.field_1352, p.field_1351, p.field_1350, v.field_1352, v.field_1351, v.field_1350);
        }
    }

    public static void increaseGunExperience(class_1657 player) {
        String NAME = "gun_experience";
        class_269 board = player.method_7327();
        class_266 objective = board.method_1170("gun_experience");
        if (objective == null) {
            objective = board.method_1168("gun_experience", class_274.field_1468, (class_2561)new class_2585("gun_experience"), class_274.class_275.field_1472);
        }
        class_267 score = board.method_1180(player.method_5820(), objective);
        score.method_1130();
    }

    public static class_1799 getActiveStack(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return activeMainHandStack;
        }
        return activeOffhandStack;
    }

    public static void setActiveStack(class_1268 hand, class_1799 stack) {
        if (hand == class_1268.field_5808) {
            activeMainHandStack = stack;
        } else {
            activeOffhandStack = stack;
        }
    }

    public static boolean isAmmo(class_1799 stack) {
        return stack.method_7909() == Items.CARTRIDGE;
    }

    public static class_1799 findAmmo(class_1657 player) {
        if (GunItem.isAmmo(player.method_6118(class_1304.field_6171))) {
            return player.method_6118(class_1304.field_6171);
        }
        if (GunItem.isAmmo(player.method_6118(class_1304.field_6173))) {
            return player.method_6118(class_1304.field_6173);
        }
        for (int i = 0; i != player.method_31548().method_5439(); ++i) {
            class_1799 itemstack = player.method_31548().method_5438(i);
            if (!GunItem.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return class_1799.field_8037;
    }

    public static boolean isLoaded(class_1799 stack) {
        return stack.method_7948().method_10571("loaded") != 0;
    }

    public static void setLoaded(class_1799 stack, boolean loaded) {
        if (loaded) {
            stack.method_7948().method_10567("loaded", (byte)1);
        } else {
            stack.method_7948().method_10551("loaded");
        }
    }

    public static int getLoadingStage(class_1799 stack) {
        return stack.method_7948().method_10550("loadingStage");
    }

    public static void setLoadingStage(class_1799 stack, int loadingStage) {
        if (loadingStage != 0) {
            stack.method_7948().method_10569("loadingStage", loadingStage);
        } else {
            stack.method_7948().method_10551("loadingStage");
        }
    }
}

