/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletRenderer;
import ewewukek.musketmod.ClientUtilities;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketMod;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        ClampedItemPropertyFunction loaded = (stack, world, player, arg) -> GunItem.isLoaded(stack) ? 1.0f : 0.0f;
        ItemProperties.register((Item)Items.MUSKET, (ResourceLocation)new ResourceLocation("loaded"), (ItemPropertyFunction)loaded);
        ItemProperties.register((Item)Items.MUSKET_WITH_BAYONET, (ResourceLocation)new ResourceLocation("loaded"), (ItemPropertyFunction)loaded);
        ItemProperties.register((Item)Items.PISTOL, (ResourceLocation)new ResourceLocation("loaded"), (ItemPropertyFunction)loaded);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRenderHandEvent(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack.m_41720_() instanceof GunItem) {
            Minecraft mc = Minecraft.m_91087_();
            ClientUtilities.renderGunInHand(mc.m_91292_(), (AbstractClientPlayer)mc.f_91074_, event.getHand(), event.getPartialTicks(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress(), stack, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        if (!(event.getEntity() instanceof Player) || !(event.getRenderer().m_7200_() instanceof PlayerModel)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Optional<HumanoidModel.ArmPose> mainHandPose = ClientUtilities.getArmPose(player, InteractionHand.MAIN_HAND);
        Optional<HumanoidModel.ArmPose> offhandPose = ClientUtilities.getArmPose(player, InteractionHand.OFF_HAND);
        PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
        if (player.m_5737_() == HumanoidArm.RIGHT) {
            model.f_102816_ = mainHandPose.isPresent() ? mainHandPose.get() : model.f_102816_;
            model.f_102815_ = offhandPose.isPresent() ? offhandPose.get() : model.f_102815_;
        } else {
            model.f_102816_ = offhandPose.isPresent() ? offhandPose.get() : model.f_102816_;
            model.f_102815_ = mainHandPose.isPresent() ? mainHandPose.get() : model.f_102815_;
        }
    }

    public static void handleSmokeEffectPacket(MusketMod.SmokeEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        PacketListener listener = ctx.get().getNetworkManager().m_129538_();
        if (listener instanceof ClientPacketListener) {
            GunItem.fireParticles((Level)((ClientPacketListener)listener).m_105147_(), packet.origin, packet.direction);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(MusketMod.BULLET_ENTITY_TYPE, BulletRenderer::new);
        }
    }
}

