/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.ClientSetup;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.Sounds;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="musketmod")
public class MusketMod {
    public static final String MODID = "musketmod";
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("musketmod.txt");
    public static EntityType<BulletEntity> BULLET_ENTITY_TYPE;
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL;

    public MusketMod() {
        Config.reload();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init));
        NETWORK_CHANNEL.registerMessage(1, SmokeEffectPacket.class, SmokeEffectPacket::encode, SmokeEffectPacket::new, SmokeEffectPacket::handle);
    }

    public static void sendSmokeEffect(LivingEntity shooter, Vec3 origin, Vec3 direction) {
        NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> shooter), (Object)new SmokeEffectPacket(origin, direction));
    }

    static {
        NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    public static class SmokeEffectPacket {
        public final Vec3 origin;
        public final Vec3 direction;

        public SmokeEffectPacket(Vec3 origin, Vec3 direction) {
            this.origin = origin;
            this.direction = direction;
        }

        public SmokeEffectPacket(FriendlyByteBuf buf) {
            this.origin = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.direction = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }

        public void encode(FriendlyByteBuf buf) {
            buf.writeFloat((float)this.origin.f_82479_);
            buf.writeFloat((float)this.origin.f_82480_);
            buf.writeFloat((float)this.origin.f_82481_);
            buf.writeFloat((float)this.direction.f_82479_);
            buf.writeFloat((float)this.direction.f_82480_);
            buf.writeFloat((float)this.direction.f_82481_);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)ctx)));
            ctx.get().setPacketHandled(true);
        }

        private /* synthetic */ Runnable lambda$handle$1(Supplier ctx) {
            return () -> this.lambda$handle$0((Supplier)ctx);
        }

        private /* synthetic */ void lambda$handle$0(Supplier ctx) {
            ClientSetup.handleSmokeEffectPacket(this, ctx);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
            event.addListener(new PreparableReloadListener(){

                public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                    return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> Config.reload(), gameExecutor);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)Items.MUSKET.setRegistryName(MusketMod.MODID, "musket"), (Item)Items.MUSKET_WITH_BAYONET.setRegistryName(MusketMod.MODID, "musket_with_bayonet"), (Item)Items.PISTOL.setRegistryName(MusketMod.MODID, "pistol"), (Item)Items.CARTRIDGE.setRegistryName(MusketMod.MODID, "cartridge")});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            BULLET_ENTITY_TYPE = EntityType.Builder.m_20704_(BulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(64).setUpdateInterval(5).setShouldReceiveVelocityUpdates(false).m_20712_("musketmod:bullet");
            event.getRegistry().register((IForgeRegistryEntry)((EntityType)BULLET_ENTITY_TYPE.setRegistryName(MusketMod.MODID, "bullet")));
        }

        @SubscribeEvent
        public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)Sounds.MUSKET_LOAD_0.setRegistryName(Sounds.MUSKET_LOAD_0.m_11660_()), (SoundEvent)Sounds.MUSKET_LOAD_1.setRegistryName(Sounds.MUSKET_LOAD_1.m_11660_()), (SoundEvent)Sounds.MUSKET_LOAD_2.setRegistryName(Sounds.MUSKET_LOAD_2.m_11660_()), (SoundEvent)Sounds.MUSKET_READY.setRegistryName(Sounds.MUSKET_READY.m_11660_()), (SoundEvent)Sounds.MUSKET_FIRE.setRegistryName(Sounds.MUSKET_FIRE.m_11660_()), (SoundEvent)Sounds.PISTOL_FIRE.setRegistryName(Sounds.PISTOL_FIRE.m_11660_())});
        }
    }
}

