/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.MusketMod;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class BulletEntity
extends class_1668 {
    public static final class_2940<Float> INITIAL_SPEED = class_2945.method_12791(BulletEntity.class, (class_2941)class_2943.field_13320);
    public static final double MIN_DAMAGE = 0.5;
    public static final double GRAVITY = 0.05;
    public static final double AIR_FRICTION = 0.99;
    public static final double WATER_FRICTION = 0.6;
    public static final short LIFETIME = 50;
    public static double maxDistance;
    public float damageMultiplier;
    public boolean ignoreInvulnerableTime;
    public float distanceTravelled;
    public short tickCounter;

    public BulletEntity(class_1299<BulletEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public BulletEntity(class_1937 world) {
        this(MusketMod.BULLET_ENTITY_TYPE, world);
    }

    public boolean isFirstTick() {
        return this.tickCounter == 0;
    }

    public class_1282 causeMusketDamage(BulletEntity bullet, class_1297 attacker) {
        return new class_1284("musket", (class_1297)bullet, attacker).method_5517();
    }

    public void discardOnNextTick() {
        this.tickCounter = (short)50;
    }

    public void method_5773() {
        class_243 pos;
        class_3965 fluidHitResult;
        class_3966 entityHitResult;
        class_3965 hitResult;
        this.tickCounter = (short)(this.tickCounter + 1);
        if (this.tickCounter >= 50 || (double)this.distanceTravelled > maxDistance) {
            this.method_31472();
            return;
        }
        class_243 motion = this.method_18798();
        class_243 from = this.method_19538();
        class_243 to = from.method_1019(motion);
        class_243 waterPos = from;
        this.field_5957 = this.method_5692(class_3486.field_15517, 0.0);
        if (this.field_5957) {
            motion = motion.method_1021(0.6);
            to = from.method_1019(motion);
            this.method_18799(motion);
        }
        if ((hitResult = this.field_6002.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this))).method_17783() != class_239.class_240.field_1333) {
            to = hitResult.method_17784();
        }
        if ((entityHitResult = this.findHitEntity(from, to)) != null) {
            hitResult = entityHitResult;
            to = hitResult.method_17784();
        }
        if (!this.field_5957 && (fluidHitResult = this.field_6002.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this))).method_17783() == class_239.class_240.field_1332) {
            class_3610 fluid = this.field_6002.method_8316(fluidHitResult.method_17777());
            double distanceToFluid = fluidHitResult.method_17784().method_1020(from).method_1033();
            double distanceToHit = to.method_1020(from).method_1033();
            if (fluid.method_15767(class_3486.field_15517)) {
                int impactParticleCount;
                this.field_5957 = true;
                waterPos = fluidHitResult.method_17784();
                double velocity = motion.method_1033();
                double timeInWater = 1.0 - distanceToFluid / velocity;
                double newVelocity = velocity * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                if (hitResult.method_17783() != class_239.class_240.field_1333) {
                    if (distanceToFluid < distanceToHit) {
                        if (distanceToHit < newVelocity) {
                            timeInWater = (distanceToHit - distanceToFluid) / velocity;
                            newVelocity = velocity * (1.0 - timeInWater + timeInWater * Math.pow(0.6, timeInWater));
                        } else {
                            hitResult = class_3965.method_17778(null, null, null);
                        }
                    } else {
                        fluidHitResult = class_3965.method_17778(null, null, null);
                    }
                }
                motion = motion.method_1021(newVelocity / velocity);
                to = from.method_1019(motion);
                this.method_18799(motion);
                if (fluidHitResult.method_17783() != class_239.class_240.field_1333 && (impactParticleCount = (int)(this.method_18798().method_1027() / 10.0)) > 0) {
                    class_243 pos2 = fluidHitResult.method_17784();
                    double yv = fluidHitResult.method_17780() == class_2350.field_11036 ? 0.02 : 0.0;
                    for (int i = 0; i < impactParticleCount; ++i) {
                        this.field_6002.method_8406((class_2394)class_2398.field_11202, pos2.field_1352, pos2.field_1351, pos2.field_1350, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01 + yv, this.field_5974.method_43059() * 0.01);
                    }
                }
            } else if (fluid.method_15767(class_3486.field_15518) && (hitResult.method_17783() == class_239.class_240.field_1333 || distanceToFluid < distanceToHit)) {
                hitResult = fluidHitResult;
                to = fluidHitResult.method_17784();
            }
        }
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            if (!this.field_6002.field_9236) {
                this.method_7488((class_239)hitResult);
                this.discardOnNextTick();
            } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
                int impactParticleCount = (int)(this.method_18798().method_1027() / 20.0);
                if (impactParticleCount > 0) {
                    class_2680 blockstate = this.field_6002.method_8320(hitResult.method_17777());
                    class_2388 particleOption = new class_2388(class_2398.field_11217, blockstate);
                    pos = hitResult.method_17784();
                    for (int i = 0; i < impactParticleCount; ++i) {
                        this.field_6002.method_8406((class_2394)particleOption, pos.field_1352, pos.field_1351, pos.field_1350, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01);
                    }
                }
                this.method_31472();
            }
        }
        if (this.field_5957) {
            double len;
            class_243 step = motion.method_1021(1.0 / len);
            pos = waterPos.method_1019(step.method_1021(0.5));
            for (len = motion.method_1033(); len > 0.5; len -= 1.0) {
                pos = pos.method_1019(step);
                this.field_6002.method_8406((class_2394)class_2398.field_11247, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
            }
        } else {
            motion = motion.method_1021(0.99);
        }
        this.method_18799(motion.method_1023(0.0, 0.05, 0.0));
        this.method_33574(to);
        this.distanceTravelled = (float)((double)this.distanceTravelled + to.method_1020(from).method_1033());
        this.method_5852();
    }

    public void method_7454(class_3966 hitResult) {
        class_1297 shooter;
        class_1297 target = hitResult.method_17782();
        if (target instanceof class_1657 && (shooter = this.method_24921()) instanceof class_1657 && !((class_1657)shooter).method_7256((class_1657)target)) {
            target = null;
        }
        if (target != null) {
            shooter = this.method_24921();
            class_1282 damagesource = this.causeMusketDamage(this, (class_1297)(shooter != null ? shooter : this));
            float damage = this.damageMultiplier * (float)this.method_18798().method_1027();
            if ((double)damage > 0.5) {
                int oldInvulnerableTime = target.field_6008;
                if (this.ignoreInvulnerableTime) {
                    target.field_6008 = 0;
                }
                boolean beenHurt = target.method_5643(damagesource, damage);
                if (this.ignoreInvulnerableTime && !beenHurt) {
                    target.field_6008 = oldInvulnerableTime;
                }
            }
        }
    }

    public class_3966 findHitEntity(class_243 start, class_243 end) {
        class_243 motion = this.method_18798();
        class_1297 resultEntity = null;
        class_243 resultVec = null;
        double resultDist = 0.0;
        class_238 aabbSelection = this.method_5829().method_18804(motion).method_1014(0.5);
        for (class_1297 entity : this.field_6002.method_8333((class_1297)this, aabbSelection, x$0 -> this.method_26958((class_1297)x$0))) {
            double dist;
            class_238 aabb = entity.method_5829();
            Optional optional = aabb.method_992(start, end);
            if (!optional.isPresent()) {
                aabb = aabb.method_989(entity.field_6038 - entity.method_23317(), entity.field_5971 - entity.method_23318(), entity.field_5989 - entity.method_23321());
                optional = aabb.method_992(start, end);
            }
            if (!optional.isPresent() || !((dist = start.method_1025((class_243)optional.get())) < resultDist) && resultEntity != null) continue;
            resultEntity = entity;
            resultVec = (class_243)optional.get();
            resultDist = dist;
        }
        return resultEntity != null ? new class_3966(resultEntity, resultVec) : null;
    }

    public void setInitialSpeed(float speed) {
        this.field_6011.method_12778(INITIAL_SPEED, (Object)Float.valueOf(speed));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(INITIAL_SPEED, (Object)Float.valueOf(0.0f));
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.damageMultiplier = compound.method_10583("damageMultiplier");
        this.ignoreInvulnerableTime = compound.method_10571("ignoreInvulnerableTime") != 0;
        this.distanceTravelled = compound.method_10583("distanceTravelled");
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("damageMultiplier", this.damageMultiplier);
        compound.method_10567("ignoreInvulnerableTime", (byte)(this.ignoreInvulnerableTime ? 1 : 0));
        compound.method_10548("distanceTravelled", this.distanceTravelled);
    }

    public class_2596<?> method_18002() {
        class_1297 owner = this.method_24921();
        return new class_2604(this.method_5628(), this.method_5667(), this.method_23317(), this.method_23318(), this.method_23321(), this.method_36455(), this.method_36454(), this.method_5864(), owner != null ? owner.method_5628() : 0, this.method_18798().method_1021(4.0 / (double)((Float)this.field_6011.method_12789(INITIAL_SPEED)).floatValue()), (double)this.method_5791());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_243 packet_velocity = new class_243(packet.method_11170(), packet.method_11172(), packet.method_11173());
        this.method_18799(packet_velocity.method_1021(0.25));
    }

    public void method_5674(class_2940<?> accessor) {
        super.method_5674(accessor);
        if (INITIAL_SPEED.equals(accessor) && this.field_6002.field_9236) {
            this.method_18799(this.method_18798().method_1021((double)((Float)this.field_6011.method_12789(INITIAL_SPEED)).floatValue()));
        }
    }
}

