/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.Sounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public abstract class GunItem
extends Item {
    public static final int LOADING_STAGE_1 = 5;
    public static final int LOADING_STAGE_2 = 10;
    public static final int LOADING_STAGE_3 = 20;
    public static final int RELOAD_DURATION = 30;
    public static ItemStack activeMainHandStack;
    public static ItemStack activeOffhandStack;

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public abstract float bulletStdDev();

    public abstract float bulletSpeed();

    public abstract float damageMultiplierMin();

    public abstract float damageMultiplierMax();

    public abstract SoundEvent fireSound();

    public abstract boolean twoHanded();

    public abstract boolean ignoreInvulnerableTime();

    public boolean canUseFrom(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return true;
        }
        if (this.twoHanded()) {
            return false;
        }
        ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!mainHandStack.m_41619_() && mainHandStack.m_41720_() instanceof GunItem) {
            return !((GunItem)mainHandStack.m_41720_()).twoHanded();
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand hand) {
        GunItem offhandGun;
        ItemStack offhandStack;
        if (!this.canUseFrom(player, hand)) {
            return super.m_7203_(worldIn, player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        boolean creative = player.m_150110_().f_35937_;
        if (player.m_204029_(FluidTags.f_13131_) && !creative) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (hand == InteractionHand.MAIN_HAND && !this.twoHanded() && GunItem.isLoaded(stack) && !(offhandStack = player.m_21120_(InteractionHand.OFF_HAND)).m_41619_() && offhandStack.m_41720_() instanceof GunItem && !(offhandGun = (GunItem)offhandStack.m_41720_()).twoHanded() && GunItem.isLoaded(offhandStack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        boolean haveAmmo = !GunItem.findAmmo(player).m_41619_() || creative;
        boolean loaded = GunItem.isLoaded(stack);
        if (loaded) {
            if (!worldIn.f_46443_) {
                Vec3 front = Vec3.m_82498_((float)player.m_146909_(), (float)player.m_146908_());
                HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                boolean isRightHand = arm == HumanoidArm.RIGHT;
                Vec3 side = Vec3.m_82498_((float)0.0f, (float)(player.m_146908_() + (float)(isRightHand ? 90 : -90)));
                Vec3 down = Vec3.m_82498_((float)(player.m_146909_() + 90.0f), (float)player.m_146908_());
                this.fire((LivingEntity)player, front, side.m_82549_(down).m_82490_(0.15));
            }
            player.m_5496_(this.fireSound(), 3.5f, 1.0f);
            GunItem.setLoaded(stack, false);
            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            if (worldIn.f_46443_) {
                GunItem.setActiveStack(hand, stack);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (haveAmmo) {
            GunItem.setLoadingStage(stack, 1);
            player.m_6672_(hand);
            if (worldIn.f_46443_) {
                GunItem.setActiveStack(hand, stack);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        GunItem.setLoadingStage(stack, 0);
    }

    public void m_5929_(Level world, LivingEntity entity, ItemStack stack, int timeLeft) {
        int usingDuration = this.m_8105_(stack) - timeLeft;
        int loadingStage = GunItem.getLoadingStage(stack);
        if (loadingStage == 1 && usingDuration >= 5) {
            entity.m_5496_(Sounds.MUSKET_LOAD_0, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 2);
        } else if (loadingStage == 2 && usingDuration >= 10) {
            entity.m_5496_(Sounds.MUSKET_LOAD_1, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 3);
        } else if (loadingStage == 3 && usingDuration >= 20) {
            entity.m_5496_(Sounds.MUSKET_LOAD_2, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 4);
        }
        if (world.f_46443_ && entity instanceof Player) {
            GunItem.setActiveStack(entity.m_7655_(), stack);
            return;
        }
        if (usingDuration >= 30 && !GunItem.isLoaded(stack)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_150110_().f_35937_) {
                    ItemStack ammoStack = GunItem.findAmmo(player);
                    if (ammoStack.m_41619_()) {
                        return;
                    }
                    ammoStack.m_41774_(1);
                    if (ammoStack.m_41619_()) {
                        player.m_150109_().m_36057_(ammoStack);
                    }
                }
            }
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.MUSKET_READY, entity.m_5720_(), 0.8f, 1.0f);
            GunItem.setLoaded(stack, true);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity enemy, LivingEntity entityIn) {
        stack.m_41622_(1, entityIn, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return false;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityIn) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.m_41622_(1, entityIn, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void fire(LivingEntity shooter, Vec3 direction) {
        this.fire(shooter, direction, Vec3.f_82478_);
    }

    public void fire(LivingEntity shooter, Vec3 direction, Vec3 smokeOriginOffset) {
        Vec3 n2;
        Vec3 n1;
        RandomSource random = shooter.m_217043_();
        Level level = shooter.f_19853_;
        float angle = (float)Math.PI * 2 * random.m_188501_();
        float gaussian = Math.abs((float)random.m_188583_());
        if (gaussian > 4.0f) {
            gaussian = 4.0f;
        }
        float spread = this.bulletStdDev() * gaussian;
        if (Math.abs(direction.f_82479_) < 1.0E-5 && Math.abs(direction.f_82481_) < 1.0E-5) {
            n1 = new Vec3(1.0, 0.0, 0.0);
            n2 = new Vec3(0.0, 0.0, 1.0);
        } else {
            n1 = new Vec3(-direction.f_82481_, 0.0, direction.f_82479_).m_82541_();
            n2 = direction.m_82537_(n1);
        }
        Vec3 motion = direction.m_82490_((double)Mth.m_14089_((float)spread)).m_82549_(n1.m_82490_((double)(Mth.m_14031_((float)spread) * Mth.m_14031_((float)angle)))).m_82549_(n2.m_82490_((double)(Mth.m_14031_((float)spread) * Mth.m_14089_((float)angle)))).m_82490_((double)this.bulletSpeed());
        Vec3 origin = new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
        BulletEntity bullet = new BulletEntity(level);
        bullet.m_5602_((Entity)shooter);
        bullet.m_146884_(origin);
        bullet.setInitialSpeed(this.bulletSpeed());
        bullet.m_20256_(motion);
        float t = random.m_188501_();
        bullet.damageMultiplier = t * this.damageMultiplierMin() + (1.0f - t) * this.damageMultiplierMax();
        bullet.ignoreInvulnerableTime = this.ignoreInvulnerableTime();
        level.m_7967_((Entity)bullet);
        MusketMod.sendSmokeEffect(shooter, origin.m_82549_(smokeOriginOffset), direction);
    }

    public static void fireParticles(Level world, Vec3 origin, Vec3 direction) {
        Random random = new Random();
        for (int i = 0; i != 10; ++i) {
            double t = Math.pow(random.nextFloat(), 1.5);
            Vec3 p = origin.m_82549_(direction.m_82490_(1.25 + t));
            p = p.m_82549_(new Vec3((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5).m_82490_(0.1));
            Vec3 v = direction.m_82490_(0.1 * (1.0 - t));
            world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
        }
    }

    public static void increaseGunExperience(Player player) {
        String NAME = "gun_experience";
        Scoreboard board = player.m_36329_();
        Objective objective = board.m_83477_("gun_experience");
        if (objective == null) {
            objective = board.m_83436_("gun_experience", ObjectiveCriteria.f_83588_, (Component)Component.m_237113_((String)"gun_experience"), ObjectiveCriteria.RenderType.INTEGER);
        }
        Score score = board.m_83471_(player.m_6302_(), objective);
        score.m_83392_();
    }

    public static ItemStack getActiveStack(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return activeMainHandStack;
        }
        return activeOffhandStack;
    }

    public static void setActiveStack(InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            activeMainHandStack = stack;
        } else {
            activeOffhandStack = stack;
        }
    }

    public static boolean isAmmo(ItemStack stack) {
        return stack.m_41720_() == Items.CARTRIDGE;
    }

    public static ItemStack findAmmo(Player player) {
        if (GunItem.isAmmo(player.m_6844_(EquipmentSlot.OFFHAND))) {
            return player.m_6844_(EquipmentSlot.OFFHAND);
        }
        if (GunItem.isAmmo(player.m_6844_(EquipmentSlot.MAINHAND))) {
            return player.m_6844_(EquipmentSlot.MAINHAND);
        }
        for (int i = 0; i != player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!GunItem.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isLoaded(ItemStack stack) {
        return stack.m_41784_().m_128445_("loaded") != 0;
    }

    public static void setLoaded(ItemStack stack, boolean loaded) {
        if (loaded) {
            stack.m_41784_().m_128344_("loaded", (byte)1);
        } else {
            stack.m_41784_().m_128473_("loaded");
        }
    }

    public static int getLoadingStage(ItemStack stack) {
        return stack.m_41784_().m_128451_("loadingStage");
    }

    public static void setLoadingStage(ItemStack stack, int loadingStage) {
        if (loadingStage != 0) {
            stack.m_41784_().m_128405_("loadingStage", loadingStage);
        } else {
            stack.m_41784_().m_128473_("loadingStage");
        }
    }
}

