/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.ClientSetup;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.Sounds;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="musketmod")
public class MusketMod {
    public static final String MODID = "musketmod";
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("musketmod.txt");
    public static EntityType<BulletEntity> BULLET_ENTITY_TYPE;
    private static final int PROTOCOL_VERSION = 2;
    public static final SimpleChannel NETWORK_CHANNEL;

    public MusketMod() {
        Config.reload();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init));
        NETWORK_CHANNEL.messageBuilder(SmokeEffectPacket.class).encoder(SmokeEffectPacket::encode).decoder(SmokeEffectPacket::decode).consumerNetworkThread(SmokeEffectPacket::handle).add();
    }

    public static void sendSmokeEffect(LivingEntity shooter, Vec3 origin, Vec3 direction) {
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(origin.f_82479_, origin.f_82480_, origin.f_82481_, 64.0, shooter.m_9236_().m_46472_());
        NETWORK_CHANNEL.send((Object)new SmokeEffectPacket(origin, direction), PacketDistributor.NEAR.with((Object)point));
    }

    static {
        NETWORK_CHANNEL = ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main")).networkProtocolVersion(2).clientAcceptedVersions(Channel.VersionTest.exact((int)2)).serverAcceptedVersions(Channel.VersionTest.exact((int)2)).simpleChannel();
    }

    public static class SmokeEffectPacket {
        public final Vec3 origin;
        public final Vec3 direction;

        public SmokeEffectPacket(Vec3 origin, Vec3 direction) {
            this.origin = origin;
            this.direction = direction;
        }

        public static SmokeEffectPacket decode(FriendlyByteBuf buf) {
            return new SmokeEffectPacket(new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat()), new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat()));
        }

        public static void encode(SmokeEffectPacket msg, FriendlyByteBuf buf) {
            buf.writeFloat((float)msg.origin.f_82479_);
            buf.writeFloat((float)msg.origin.f_82480_);
            buf.writeFloat((float)msg.origin.f_82481_);
            buf.writeFloat((float)msg.direction.f_82479_);
            buf.writeFloat((float)msg.direction.f_82480_);
            buf.writeFloat((float)msg.direction.f_82481_);
        }

        public static void handle(SmokeEffectPacket msg, CustomPayloadEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                ClientSetup.handleSmokeEffectPacket(level, msg);
            });
            ctx.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
            event.addListener(new PreparableReloadListener(){

                public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                    return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> Config.reload(), gameExecutor);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterEvent(RegisterEvent event) {
            event.register(ForgeRegistries.Keys.ITEMS, helper -> {
                helper.register("musket", (Object)Items.MUSKET);
                helper.register("musket_with_bayonet", (Object)Items.MUSKET_WITH_BAYONET);
                helper.register("pistol", (Object)Items.PISTOL);
                helper.register("cartridge", (Object)Items.CARTRIDGE);
            });
            event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> {
                BULLET_ENTITY_TYPE = EntityType.Builder.m_20704_(BulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(64).setUpdateInterval(5).setShouldReceiveVelocityUpdates(false).m_20712_("musketmod:bullet");
                helper.register("bullet", BULLET_ENTITY_TYPE);
            });
            event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> {
                helper.register(Sounds.MUSKET_LOAD_0.m_11660_(), (Object)Sounds.MUSKET_LOAD_0);
                helper.register(Sounds.MUSKET_LOAD_1.m_11660_(), (Object)Sounds.MUSKET_LOAD_1);
                helper.register(Sounds.MUSKET_LOAD_2.m_11660_(), (Object)Sounds.MUSKET_LOAD_2);
                helper.register(Sounds.MUSKET_READY.m_11660_(), (Object)Sounds.MUSKET_READY);
                helper.register(Sounds.MUSKET_FIRE.m_11660_(), (Object)Sounds.MUSKET_FIRE);
                helper.register(Sounds.PISTOL_FIRE.m_11660_(), (Object)Sounds.PISTOL_FIRE);
            });
        }

        @SubscribeEvent
        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256797_) {
                event.m_246326_((ItemLike)Items.MUSKET);
                event.m_246326_((ItemLike)Items.MUSKET_WITH_BAYONET);
                event.m_246326_((ItemLike)Items.PISTOL);
                event.m_246326_((ItemLike)Items.CARTRIDGE);
            }
        }
    }
}

