/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.blocks.entities.CustomBlockEntity;
import com.devbobcorn.nekoration.items.ModItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CustomBlock
extends Block {
    public static final IntegerProperty MODEL = BlockStateProperties.field_208132_ag;

    public CustomBlock(AbstractBlock.Properties settings) {
        super(settings);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> s) {
        s.func_206894_a(new Property[]{MODEL});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CustomBlockEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CustomBlockEntity) {
            CustomBlockEntity te = (CustomBlockEntity)tileEntity;
            switch (placer.func_174811_aO().func_176734_d()) {
                default: {
                    break;
                }
                case EAST: {
                    te.dir = 6;
                    break;
                }
                case NORTH: {
                    te.dir = 12;
                    break;
                }
                case WEST: {
                    te.dir = 18;
                }
            }
            return;
        }
        field_196273_d.error("Tile Entity NOT Found!");
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(hand);
        Item item = itemStack.func_77973_b();
        CustomBlockEntity te = (CustomBlockEntity)world.func_175625_s(pos);
        if (item == ModItems.PAW_15.get()) {
            te.dir = (byte)((te.dir + 1) % 24);
            return ActionResultType.CONSUME;
        }
        if (item == ModItems.PAW_90.get()) {
            te.dir = (byte)((te.dir + 6) % 24);
            return ActionResultType.CONSUME;
        }
        if (item == ModItems.PAW_LEFT.get()) {
            te.offset[0] = te.offset[0] - 1;
        } else if (item == ModItems.PAW_RIGHT.get()) {
            te.offset[0] = te.offset[0] + 1;
        } else if (item == ModItems.PAW_UP.get()) {
            te.offset[1] = te.offset[1] + 1;
        } else if (item == ModItems.PAW_DOWN.get()) {
            te.offset[1] = te.offset[1] - 1;
        } else if (item == ModItems.PAW_NEAR.get()) {
            te.offset[2] = te.offset[2] + 1;
        } else if (item == ModItems.PAW_FAR.get()) {
            te.offset[2] = te.offset[2] - 1;
        } else if (item == ModItems.PALETTE.get()) {
            CompoundNBT nbt = itemStack.func_77978_p();
            byte a = nbt.func_74771_c("active");
            int[] c = nbt.func_74759_k("colors");
            te.color[0] = NekoColors.getRed(c[a]);
            te.color[1] = NekoColors.getGreen(c[a]);
            te.color[2] = NekoColors.getBlue(c[a]);
            System.out.println("Dye Custom Block!");
        } else if (item instanceof BlockItem) {
            if (((BlockItem)item).func_179223_d() instanceof CustomBlock) {
                return ActionResultType.PASS;
            }
            te.model = 16;
            BlockState newState = ((BlockItem)item).func_179223_d().func_196258_a(new BlockItemUseContext(player, hand, itemStack, hit));
            if (te.displayBlock == newState) {
                return ActionResultType.PASS;
            }
            te.displayBlock = newState;
            ItemStack newStack = itemStack.func_77946_l();
            newStack.func_190920_e(1);
            te.containItem = newStack;
        } else {
            return ActionResultType.PASS;
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
        return Collections.singletonList(stack);
    }
}

