/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.common.VanillaCompat;
import com.devbobcorn.nekoration.items.DyeableBlockItem;
import com.devbobcorn.nekoration.items.DyeableWoodenBlockItem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DyeableBlock
extends Block {
    public static final IntegerProperty COLOR = BlockStateProperties.field_208132_ag;

    public DyeableBlock(AbstractBlock.Properties settings) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> s) {
        s.func_206894_a(new Property[]{COLOR});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return VanillaCompat.COLOR_ITEMS.containsKey(itemStack.func_77973_b()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (VanillaCompat.COLOR_ITEMS.containsKey(itemStack.func_77973_b())) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COLOR, (Comparable)VanillaCompat.COLOR_ITEMS.get(itemStack.func_77973_b())), 3);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        if (stack.func_77973_b() instanceof DyeableBlockItem) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(DyeableBlockItem.getColor(stack).getNBTId()));
        }
        if (stack.func_77973_b() instanceof DyeableWoodenBlockItem) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(DyeableWoodenBlockItem.getColor(stack).getNBTId()));
        }
        return this.func_176223_P();
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
        DyeableBlockItem.setColor(stack, NekoColors.EnumNekoColor.getColorEnumFromID(((Integer)state.func_177229_b((Property)COLOR)).byteValue()));
        return stack;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
        DyeableBlockItem.setColor(stack, NekoColors.EnumNekoColor.getColorEnumFromID(((Integer)state.func_177229_b((Property)COLOR)).byteValue()));
        return Collections.singletonList(stack);
    }
}

