/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.blocks.DyeableHorizontalBlock;
import com.devbobcorn.nekoration.blocks.states.HorizontalConnection;
import com.devbobcorn.nekoration.blocks.states.ModStateProperties;
import com.devbobcorn.nekoration.common.VanillaCompat;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DyeableHorizontalConnectBlock
extends DyeableHorizontalBlock {
    protected static Double thickness = 6.0;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)(16.0 - thickness), (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)thickness), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)16.0, (double)16.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)(16.0 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
    public static final IntegerProperty COLOR = BlockStateProperties.field_208132_ag;
    public static final EnumProperty<HorizontalConnection> CONNECTION = ModStateProperties.HONRIZONTAL_CONNECTION;
    public final ConnectionType type;
    public final boolean connectOthers;

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> s) {
        s.func_206894_a(new Property[]{COLOR, FACING, CONNECTION});
    }

    public DyeableHorizontalConnectBlock(AbstractBlock.Properties settings) {
        super(settings);
        this.type = ConnectionType.TRIPLE;
        this.connectOthers = false;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    public DyeableHorizontalConnectBlock(AbstractBlock.Properties settings, ConnectionType tp, boolean co) {
        super(settings);
        this.type = tp;
        this.connectOthers = co;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return AABBS.get(state.func_177229_b((Property)FACING));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return VanillaCompat.COLOR_ITEMS.containsKey(itemStack.func_77973_b()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (VanillaCompat.COLOR_ITEMS.containsKey(itemStack.func_77973_b())) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COLOR, (Comparable)VanillaCompat.COLOR_ITEMS.get(itemStack.func_77973_b())), 3);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockPos blockPos;
        BlockPos blockPosL;
        World blockView = ctx.func_195991_k();
        BlockState stateL = blockView.func_180495_p(blockPosL = this.getLeftBlock(blockPos = ctx.func_195995_a(), ctx.func_195992_f().func_176734_d()));
        if (stateL.func_177230_c() instanceof DyeableHorizontalConnectBlock && (this.connectOthers || stateL.func_177230_c() == this)) {
            switch ((HorizontalConnection)((Object)stateL.func_177229_b(CONNECTION))) {
                case S0: {
                    return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                }
                case D0: {
                    return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                }
                case T0: {
                    return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.D1));
                }
                case D1: {
                    return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.DOUBLE ? HorizontalConnection.S0 : HorizontalConnection.T2)));
                }
                case T1: {
                    return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.T2));
                }
                case T2: {
                    return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.BEAM ? HorizontalConnection.T2 : HorizontalConnection.S0)));
                }
            }
            return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.T2));
        }
        return (BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.S0));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        BlockState res = state;
        if (direction == this.getRightDir((Direction)state.func_177229_b((Property)FACING)) && newState.func_177230_c() instanceof DyeableHorizontalConnectBlock && (this.connectOthers || newState.func_177230_c() == this)) {
            BlockState stateL = world.func_180495_p(this.getLeftBlock(pos, (Direction)state.func_177229_b((Property)FACING)));
            switch ((HorizontalConnection)((Object)newState.func_177229_b(CONNECTION))) {
                case D1: {
                    return (BlockState)res.func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.D0));
                }
                case T1: {
                    return (BlockState)res.func_206870_a(CONNECTION, (Comparable)((Object)(this.type == ConnectionType.BEAM && stateL.func_177230_c() instanceof DyeableHorizontalConnectBlock && (this.connectOthers || stateL.func_177230_c() == this) ? HorizontalConnection.T1 : HorizontalConnection.T0)));
                }
                case T2: {
                    return (BlockState)res.func_206870_a(CONNECTION, (Comparable)((Object)HorizontalConnection.T1));
                }
            }
        }
        return res;
    }

    public BlockPos getLeftBlock(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos.func_177974_f();
            }
            case EAST: {
                return pos.func_177968_d();
            }
            case SOUTH: {
                return pos.func_177976_e();
            }
        }
        return pos.func_177978_c();
    }

    public BlockPos getRightBlock(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos.func_177976_e();
            }
            case EAST: {
                return pos.func_177978_c();
            }
            case SOUTH: {
                return pos.func_177974_f();
            }
        }
        return pos.func_177968_d();
    }

    public Direction getLeftDir(Direction selfDir) {
        switch (selfDir) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public Direction getRightDir(Direction selfDir) {
        switch (selfDir) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
        }
        return Direction.SOUTH;
    }

    public static enum ConnectionType {
        DOUBLE,
        TRIPLE,
        BEAM;

    }
}

