/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.blocks.DyeableHorizontalBlock;
import com.devbobcorn.nekoration.blocks.entities.EaselMenuBlockEntity;
import com.devbobcorn.nekoration.items.DyeableWoodenBlockItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EaselMenuBlock
extends DyeableHorizontalBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public final boolean white;

    public EaselMenuBlock(AbstractBlock.Properties settings, boolean w) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)COLOR, (Comparable)Integer.valueOf(2)));
        this.white = w;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        EaselMenuBlockEntity te = new EaselMenuBlockEntity(this.white);
        return te;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof EaselMenuBlockEntity) {
            EaselMenuBlockEntity te = (EaselMenuBlockEntity)tileEntity;
            if (this.white) {
                DyeColor[] colors = new DyeColor[]{DyeColor.PURPLE, DyeColor.PINK, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.BLUE};
                te.setColors(colors);
            } else {
                DyeColor[] colors = new DyeColor[]{DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE};
                te.setColors(colors);
            }
            return;
        }
        System.err.println("Tile Entity NOT Found!");
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider namedContainerProvider = this.func_220052_b(state, world, pos);
        if (namedContainerProvider != null) {
            if (!(player instanceof ServerPlayerEntity)) {
                return ActionResultType.FAIL;
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, packetBuffer -> {
                int i;
                EaselMenuBlockEntity te = (EaselMenuBlockEntity)world.func_175625_s(pos);
                packetBuffer.func_179255_a(pos);
                for (i = 0; i < 8; ++i) {
                    packetBuffer.func_179256_a(te.getMessage(i));
                }
                for (i = 0; i < 8; ++i) {
                    packetBuffer.func_179249_a((Enum)te.getColors()[i]);
                }
                packetBuffer.writeBoolean(this.white);
                packetBuffer.writeBoolean(te.getGlowing());
            });
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof EaselMenuBlockEntity) {
                EaselMenuBlockEntity tileEntityInventoryBasic = (EaselMenuBlockEntity)tileentity;
                tileEntityInventoryBasic.dropAllContents(world, pos);
            }
            world.func_175713_t(pos);
        }
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
        DyeableWoodenBlockItem.setColor(stack, NekoColors.EnumWoodenColor.getColorEnumFromID(((Integer)state.func_177229_b((Property)COLOR)).byteValue()));
        return stack;
    }
}

