/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks.containers;

import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerContents
implements IInventory {
    TileEntity tien;
    private Predicate<PlayerEntity> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda;
    private Notify openInventoryNotificationLambda;
    private Notify closeInventoryNotificationLambda;
    private final ItemStackHandler contents;

    public static ContainerContents createForTileEntity(int size, Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda, TileEntity te) {
        return new ContainerContents(size, canPlayerAccessInventoryLambda, markDirtyNotificationLambda, te);
    }

    public static ContainerContents createForClientSideContainer(int size) {
        return new ContainerContents(size);
    }

    public CompoundNBT serializeNBT() {
        return this.contents.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.contents.deserializeNBT(nbt);
    }

    public void setCanPlayerAccessInventoryLambda(Predicate<PlayerEntity> canPlayerAccessInventoryLambda) {
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
    }

    public void setMarkDirtyNotificationLambda(Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public void setOpenInventoryNotificationLambda(Notify openInventoryNotificationLambda) {
        this.openInventoryNotificationLambda = openInventoryNotificationLambda;
    }

    public void setCloseInventoryNotificationLambda(Notify closeInventoryNotificationLambda) {
        this.closeInventoryNotificationLambda = closeInventoryNotificationLambda;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.contents.isItemValid(index, stack);
    }

    public void func_70296_d() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void func_174889_b(PlayerEntity player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void func_174886_c(PlayerEntity player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int func_70302_i_() {
        return this.contents.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            if (this.contents.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.contents.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.contents.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        int maxPossibleItemStackSize = this.contents.getSlotLimit(index);
        return this.contents.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.contents.setStackInSlot(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            this.contents.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private ContainerContents(int size) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> System.out.println("Contents Closed!");
        this.contents = new ItemStackHandler(size);
    }

    private ContainerContents(int size, Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda, TileEntity te) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> System.out.println("Contents Closed!");
        this.contents = new ItemStackHandler(size);
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
        this.tien = te;
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

