/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks.containers;

import com.devbobcorn.nekoration.blocks.containers.ContainerContents;
import com.devbobcorn.nekoration.blocks.containers.ModContainerType;
import com.devbobcorn.nekoration.blocks.entities.EaselMenuBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EaselMenuContainer
extends Container {
    public final boolean white;
    public ITextComponent[] texts = new ITextComponent[8];
    public DyeColor[] colors = new DyeColor[8];
    public boolean glow;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 8;
    public static final int TILE_INVENTORY_YPOS = 18;
    public static final int PLAYER_INVENTORY_YPOS = 140;
    public BlockPos pos = BlockPos.field_177992_a;
    private ContainerContents easelMenuContents;
    private static final Logger LOGGER = LogManager.getLogger();

    public static EaselMenuContainer createContainerServerSide(int windowID, PlayerInventory playerInventory, ContainerContents easelMenuContents, EaselMenuBlockEntity te) {
        return new EaselMenuContainer(windowID, playerInventory, easelMenuContents, te.func_174877_v(), te.getMessages(), te.getColors(), te.white, te.getGlowing());
    }

    public static EaselMenuContainer createContainerClientSide(int windowID, PlayerInventory playerInventory, PacketBuffer extraData) {
        try {
            int i;
            ContainerContents easelMenuContents = ContainerContents.createForClientSideContainer(8);
            BlockPos p = extraData.func_179259_c();
            ITextComponent[] t = new ITextComponent[8];
            DyeColor[] c = new DyeColor[8];
            for (i = 0; i < 8; ++i) {
                t[i] = extraData.func_179258_d();
            }
            for (i = 0; i < 8; ++i) {
                c[i] = (DyeColor)extraData.func_179257_a(DyeColor.class);
            }
            boolean w = extraData.readBoolean();
            boolean g = extraData.readBoolean();
            return new EaselMenuContainer(windowID, playerInventory, easelMenuContents, p, t, c, w, g);
        }
        catch (Exception e) {
            LOGGER.warn("Invalid data in packet buffer", (Throwable)e);
            ContainerContents easelMenuContents = ContainerContents.createForClientSideContainer(8);
            return new EaselMenuContainer(windowID, playerInventory, easelMenuContents, BlockPos.field_177992_a, new ITextComponent[8], new DyeColor[8], false, true);
        }
    }

    private EaselMenuContainer(int windowID, PlayerInventory playerInventory, ContainerContents easelMenuContents, BlockPos pos, ITextComponent[] texts, DyeColor[] colors, boolean white, boolean glow) {
        super((ContainerType)ModContainerType.EASEL_MENU_TYPE.get(), windowID);
        int slotNumber;
        int x;
        if (ModContainerType.EASEL_MENU_TYPE.get() == null) {
            throw new IllegalStateException("Must initialize Container Type before constructing a Container!");
        }
        PlayerInvWrapper playerInventoryForge = new PlayerInvWrapper(playerInventory);
        this.easelMenuContents = easelMenuContents;
        this.white = white;
        this.glow = glow;
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 198;
        for (int x2 = 0; x2 < 9; ++x2) {
            int slotNumber2 = x2;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryForge, slotNumber2, 8 + 18 * x2, 198));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 140 + y * 18;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryForge, slotNumber, xpos, ypos));
            }
        }
        if (8 != easelMenuContents.func_70302_i_()) {
            LOGGER.warn("Mismatched slot count in ContainerBasic(8) and TileInventory (" + easelMenuContents.func_70302_i_() + ")");
        }
        int TILE_INVENTORY_XPOS = 8;
        for (x = 0; x < 8; ++x) {
            slotNumber = x;
            this.func_75146_a(new Slot((IInventory)easelMenuContents, slotNumber, 8 + 18 * (x > 3 ? x + 1 : x), 18));
        }
        this.pos = pos;
        this.texts = texts;
        this.colors = colors;
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return this.easelMenuContents.func_70300_a(playerEntity);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (!this.func_75135_a(sourceStack, 36, 44, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 44) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            LOGGER.warn("Invalid slotIndex:" + sourceSlotIndex);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(playerEntity, sourceStack);
        return copyOfSourceStack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }
}

