/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks.entities;

import com.devbobcorn.nekoration.blocks.containers.ContainerContents;
import com.devbobcorn.nekoration.blocks.containers.EaselMenuContainer;
import com.devbobcorn.nekoration.blocks.entities.ModTileEntityType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EaselMenuBlockEntity
extends TileEntity
implements INamedContainerProvider {
    public static final int NUMBER_OF_SLOTS = 8;
    public final ContainerContents contents;
    private final ITextComponent[] messages = new ITextComponent[]{StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_};
    private final ItemStack airStack = new ItemStack((IItemProvider)Items.field_190931_a);
    public ItemStack[] renderItems = new ItemStack[]{this.airStack, this.airStack, this.airStack, this.airStack, this.airStack, this.airStack, this.airStack, this.airStack};
    private boolean isEditable = true;
    private PlayerEntity playerWhoMayEdit;
    private DyeColor[] textColors = new DyeColor[]{DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY};
    private boolean isGlowing;
    public final boolean white;

    public EaselMenuBlockEntity() {
        super((TileEntityType)ModTileEntityType.EASEL_MENU_TYPE.get());
        this.white = false;
        this.isGlowing = false;
        this.contents = ContainerContents.createForTileEntity(8, this::canPlayerAccessInventory, () -> ((EaselMenuBlockEntity)this).func_70296_d(), this);
    }

    public EaselMenuBlockEntity(boolean w) {
        super((TileEntityType)ModTileEntityType.EASEL_MENU_TYPE.get());
        this.white = w;
        this.isGlowing = false;
        this.contents = ContainerContents.createForTileEntity(8, this::canPlayerAccessInventory, () -> ((EaselMenuBlockEntity)this).func_70296_d(), this);
    }

    public boolean canPlayerAccessInventory(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        int i;
        super.func_189515_b(tag);
        for (i = 0; i < 8; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.messages[i]);
            tag.func_74778_a("Text" + (i + 1), s);
        }
        for (i = 0; i < 8; ++i) {
            tag.func_74778_a("Color" + i, this.textColors[i].func_176762_d());
        }
        CompoundNBT inventoryNBT = this.contents.serializeNBT();
        tag.func_218657_a("Contents", (INBT)inventoryNBT);
        tag.func_74757_a("Glowing", this.isGlowing);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        int i;
        this.isEditable = false;
        super.func_230337_a_(state, tag);
        CompoundNBT inventoryNBT = tag.func_74775_l("Contents");
        this.contents.deserializeNBT(inventoryNBT);
        if (this.contents.func_70302_i_() != 8) {
            throw new IllegalArgumentException("Corrupted NBT: Number of inventory slots did not match expected.");
        }
        for (i = 0; i < 8; ++i) {
            this.textColors[i] = DyeColor.func_204271_a((String)tag.func_74779_i("Color" + i), (DyeColor)DyeColor.GRAY);
        }
        for (i = 0; i < 8; ++i) {
            String s = tag.func_74779_i("Text" + (i + 1));
            IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_((String)(s.isEmpty() ? "\"\"" : s));
            if (this.field_145850_b instanceof ServerWorld) {
                try {
                    this.messages[i] = TextComponentUtils.func_240645_a_((CommandSource)this.createCommandSourceStack(null), (ITextComponent)itextcomponent, (Entity)null, (int)0);
                }
                catch (CommandSyntaxException commandsyntaxexception) {
                    this.messages[i] = itextcomponent;
                }
                continue;
            }
            this.messages[i] = itextcomponent;
        }
        for (i = 0; i < 8; ++i) {
            this.renderItems[i] = this.contents.func_70301_a(i);
        }
        this.isGlowing = tag.func_74767_n("Glowing");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 2020, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (!editable) {
            this.playerWhoMayEdit = null;
        }
    }

    public void setAllowedPlayerEditor(PlayerEntity player) {
        this.playerWhoMayEdit = player;
    }

    public PlayerEntity getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public boolean executeClickCommands(PlayerEntity player) {
        for (ITextComponent itextcomponent : this.messages) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            player.func_184102_h().func_195571_aL().func_197059_a(this.createCommandSourceStack((ServerPlayerEntity)player), clickevent.func_150668_b());
        }
        return true;
    }

    public CommandSource createCommandSourceStack(@Nullable ServerPlayerEntity player) {
        String s = player == null ? "EaselMenu" : player.func_200200_C_().getString();
        StringTextComponent itextcomponent = player == null ? new StringTextComponent("EaselMenu") : player.func_145748_c_();
        return new CommandSource(ICommandSource.field_213139_a_, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), Vector2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), (Entity)player);
    }

    public void dropAllContents(World world, BlockPos blockPos) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)this.contents);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return EaselMenuContainer.createContainerServerSide(windowID, playerInventory, this.contents, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.nekoration.easel_menu");
    }

    public ITextComponent getMessage(int line) {
        return this.messages[line];
    }

    public void setMessage(int line, ITextComponent text) {
        this.messages[line] = text;
    }

    public ITextComponent[] getMessages() {
        return this.messages;
    }

    public DyeColor[] getColors() {
        return this.textColors;
    }

    public void setColors(DyeColor[] color) {
        this.textColors = color;
    }

    public boolean getGlowing() {
        return this.isGlowing;
    }

    public void setGlowing(boolean glow) {
        this.isGlowing = glow;
    }
}

