/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.event;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.client.gui.widget.IconButton;
import com.devbobcorn.nekoration.client.gui.widget.WoodTypeButton;
import com.devbobcorn.nekoration.items.HalfTimberBlockItem;
import com.devbobcorn.nekoration.items.ModItemTabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreativeInventoryEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("nekoration", "textures/gui/icons.png");
    private static int startIndex;
    private List<WoodFilter> filters;
    private List<WoodTypeButton> buttons;
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private boolean viewingFurnitureTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;
    private static final Logger LOGGER;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.filters = null;
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            if (this.filters == null) {
                this.compileItems();
            }
            this.viewingFurnitureTab = false;
            this.guiCenterX = ((CreativeScreen)event.getGui()).getGuiLeft();
            this.guiCenterY = ((CreativeScreen)event.getGui()).getGuiTop();
            this.buttons = new ArrayList<WoodTypeButton>();
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, (ITextComponent)new TranslationTextComponent("gui.nekoration.button.scroll_up"), button -> {
                if (startIndex > 0) {
                    --startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 64, 0);
            event.addWidget((Widget)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, (ITextComponent)new TranslationTextComponent("gui.nekoration.button.scroll_down"), button -> {
                if (startIndex <= this.filters.size() - 4 - 1) {
                    ++startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 80, 0);
            event.addWidget((Widget)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX + 32, this.guiCenterY - 50, (ITextComponent)new TranslationTextComponent("gui.nekoration.button.enable_all"), button -> {
                this.filters.forEach(filters -> filters.setEnabled(true));
                this.buttons.forEach(WoodTypeButton::updateState);
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof CreativeScreen) {
                    this.updateItems((CreativeScreen)screen);
                }
            }, ICONS, 96, 0);
            event.addWidget((Widget)this.btnEnableAll);
            this.btnDisableAll = new IconButton(this.guiCenterX + 144, this.guiCenterY - 50, (ITextComponent)new TranslationTextComponent("gui.nekoration.button.disable_all"), button -> {
                this.filters.forEach(filters -> filters.setEnabled(false));
                this.buttons.forEach(WoodTypeButton::updateState);
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof CreativeScreen) {
                    this.updateItems((CreativeScreen)screen);
                }
            }, ICONS, 112, 0);
            event.addWidget((Widget)this.btnDisableAll);
            this.btnScrollUp.field_230694_p_ = false;
            this.btnScrollDown.field_230694_p_ = false;
            this.btnEnableAll.field_230694_p_ = false;
            this.btnDisableAll.field_230694_p_ = false;
            this.updateTagButtons();
            CreativeScreen screen = (CreativeScreen)event.getGui();
            if (screen.func_147056_g() == ModItemTabs.WOODEN_GROUP.func_78021_a()) {
                this.btnScrollUp.field_230694_p_ = true;
                this.btnScrollDown.field_230694_p_ = true;
                this.btnEnableAll.field_230694_p_ = true;
                this.btnDisableAll.field_230694_p_ = true;
                this.viewingFurnitureTab = true;
                this.buttons.forEach(button -> {
                    button.field_230694_p_ = true;
                });
                this.updateItems(screen);
            }
        }
    }

    @SubscribeEvent
    public void onScreenClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getButton() != 0) {
            return;
        }
        if (event.getGui() instanceof CreativeScreen) {
            for (Button button : this.buttons) {
                if (!button.func_231047_b_(event.getMouseX(), event.getMouseY()) || !button.func_231044_a_(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            if (screen.func_147056_g() == ModItemTabs.WOODEN_GROUP.func_78021_a()) {
                if (!this.viewingFurnitureTab) {
                    this.updateItems(screen);
                    this.viewingFurnitureTab = true;
                }
            } else {
                this.viewingFurnitureTab = false;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            this.guiCenterX = screen.getGuiLeft();
            this.guiCenterY = screen.getGuiTop();
            if (screen.func_147056_g() == ModItemTabs.WOODEN_GROUP.func_78021_a()) {
                this.btnScrollUp.field_230694_p_ = true;
                this.btnScrollDown.field_230694_p_ = true;
                this.btnEnableAll.field_230694_p_ = true;
                this.btnDisableAll.field_230694_p_ = true;
                this.buttons.forEach(button -> {
                    button.field_230694_p_ = true;
                });
                this.buttons.forEach(button -> button.func_230430_a_(event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()));
                this.buttons.forEach(button -> {
                    if (button.func_231047_b_(event.getMouseX(), event.getMouseY())) {
                        screen.func_238652_a_(event.getMatrixStack(), (ITextComponent)button.getCategory().getName(), event.getMouseX(), event.getMouseY());
                    }
                });
                if (this.btnEnableAll.func_231047_b_((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.func_238652_a_(event.getMatrixStack(), this.btnEnableAll.func_230458_i_(), event.getMouseX(), event.getMouseY());
                }
                if (this.btnDisableAll.func_231047_b_((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.func_238652_a_(event.getMatrixStack(), this.btnDisableAll.func_230458_i_(), event.getMouseX(), event.getMouseY());
                }
            } else {
                this.btnScrollUp.field_230694_p_ = false;
                this.btnScrollDown.field_230694_p_ = false;
                this.btnEnableAll.field_230694_p_ = false;
                this.btnDisableAll.field_230694_p_ = false;
                this.buttons.forEach(button -> {
                    button.field_230694_p_ = false;
                });
            }
        }
    }

    private void updateTagButtons() {
        Button.IPressable pressable = button -> {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof CreativeScreen) {
                this.updateItems((CreativeScreen)screen);
            }
        };
        this.buttons.clear();
        for (int i = startIndex; i < startIndex + 4 && i < this.filters.size(); ++i) {
            WoodTypeButton button2 = new WoodTypeButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - startIndex) + 10, this.filters.get(i), pressable);
            this.buttons.add(button2);
        }
        this.btnScrollUp.field_230693_o_ = startIndex > 0;
        this.btnScrollDown.field_230693_o_ = startIndex <= this.filters.size() - 4 - 1;
    }

    private void updateItems(CreativeScreen screen) {
        CreativeScreen.CreativeContainer container = (CreativeScreen.CreativeContainer)screen.func_212873_a_();
        NonNullList newItems = NonNullList.func_191196_a();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.func_77640_w() == ModItemTabs.WOODEN_GROUP).filter(item -> item.getRegistryName().func_110624_b().equals("nekoration")).forEach(item -> {
            for (WoodFilter filter : this.filters) {
                if (!filter.isEnabled() || !(item instanceof HalfTimberBlockItem)) continue;
                ((HalfTimberBlockItem)((Object)item)).fillItemCategoryWithWoodType(ModItemTabs.WOODEN_GROUP, filter.getWood(), (NonNullList<ItemStack>)newItems);
            }
        });
        container.field_148330_a.clear();
        container.field_148330_a.addAll((Collection)newItems);
        container.field_148330_a.sort(Comparator.comparingInt(o -> Item.func_150891_b((Item)o.func_77973_b())));
        container.func_148329_a(0.0f);
    }

    private void compileItems() {
        WoodFilter OAK = new WoodFilter(NekoColors.EnumWoodenColor.LIGHT_GRAY, new ItemStack((IItemProvider)Blocks.field_196662_n));
        WoodFilter BIRCH = new WoodFilter(NekoColors.EnumWoodenColor.WHITE, new ItemStack((IItemProvider)Blocks.field_196666_p));
        WoodFilter ACACIA = new WoodFilter(NekoColors.EnumWoodenColor.ORANGE, new ItemStack((IItemProvider)Blocks.field_196670_r));
        WoodFilter JUNGLE = new WoodFilter(NekoColors.EnumWoodenColor.GRAY, new ItemStack((IItemProvider)Blocks.field_196668_q));
        WoodFilter SPRUCE = new WoodFilter(NekoColors.EnumWoodenColor.BROWN, new ItemStack((IItemProvider)Blocks.field_196664_o));
        WoodFilter WARPED = new WoodFilter(NekoColors.EnumWoodenColor.CYAN, new ItemStack((IItemProvider)Blocks.field_235345_mD_));
        WoodFilter CRIMSON = new WoodFilter(NekoColors.EnumWoodenColor.MAGENTA, new ItemStack((IItemProvider)Blocks.field_235344_mC_));
        WoodFilter DARK_OAK = new WoodFilter(NekoColors.EnumWoodenColor.BLACK, new ItemStack((IItemProvider)Blocks.field_196672_s));
        WoodFilter[] filters = new WoodFilter[]{OAK, BIRCH, ACACIA, JUNGLE, SPRUCE, WARPED, CRIMSON, DARK_OAK};
        this.filters = new ArrayList<WoodFilter>();
        this.filters.addAll(Arrays.asList(filters));
    }

    static {
        LOGGER = LogManager.getLogger((String)"Creative Tab");
    }

    public static class WoodFilter {
        private final NekoColors.EnumWoodenColor wood;
        private final TranslationTextComponent name;
        private final ItemStack icon;
        private boolean enabled = true;

        public WoodFilter(NekoColors.EnumWoodenColor type, ItemStack icon) {
            this.wood = type;
            this.name = new TranslationTextComponent(String.format("color.wooden.%s", type.func_176610_l().replace("/", ".")));
            this.icon = icon;
        }

        public NekoColors.EnumWoodenColor getWood() {
            return this.wood;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public TranslationTextComponent getName() {
            return this.name;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

