/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.gui.screen;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.network.C2SUpdatePaletteData;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PaletteScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("nekoration", "textures/gui/palette.png");
    public static final int COLORMAP_LEFT = 9;
    public static final int COLORMAP_TOP = 32;
    public static final int COLORMAP_WIDTH = 128;
    public static final int COLORMAP_HEIGHT = 128;
    public static final int HUE_LEFT = 141;
    public static final int HUE_TOP = 32;
    public static final int HUE_WIDTH = 6;
    public static final int HUE_HEIGHT = 128;
    public static final int white = -1;
    public static final int black = -16777216;
    private final int imageWidth = 156;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private Color colorMapColor = Color.RED;
    private Color[] colors = new Color[6];
    private byte activeSlot = 0;
    private int huePos = -1;
    private int[] colorPos = new int[]{-1, -1};
    private Hand hand;
    public boolean renderColorText = false;
    private TranslationTextComponent tipMessage;

    public PaletteScreen(Hand hand, byte active, Color[] oldColors) {
        super(ITextComponent.func_244388_a((String)"PALETTE"));
        this.hand = hand;
        this.activeSlot = active;
        this.colors = oldColors;
        this.tipMessage = new TranslationTextComponent("gui.nekoration.message.press_key_color_info", new Object[]{"'E'"});
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        this.topPos = (this.field_230709_l_ - this.imageHeight) / 2;
    }

    public void func_231175_as__() {
        try {
            int[] cls = new int[6];
            for (int idx = 0; idx < 6; ++idx) {
                cls[idx] = this.colors[idx].getRGB();
            }
            C2SUpdatePaletteData packet = new C2SUpdatePaletteData(this.hand, this.activeSlot, cls);
            ModPacketHandler.CHANNEL.sendToServer((Object)packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.func_231175_as__();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 69) {
            this.renderColorText = !this.renderColorText;
            return true;
        }
        if (keyCode == 256) {
            Objects.requireNonNull(Objects.requireNonNull(this.field_230706_i_).field_71439_g).func_71053_j();
        }
        return super.func_231046_a_(keyCode, scanCode, modifier);
    }

    public void func_230430_a_(MatrixStack stack, int x, int y, float partialTicks) {
        int i = this.leftPos;
        int j = this.topPos;
        super.func_230430_a_(stack, x, y, partialTicks);
        this.func_238468_a_(stack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        for (int idx = 0; idx < 6; ++idx) {
            RenderSystem.color4f((float)((float)this.colors[idx].getRed() / 255.0f), (float)((float)this.colors[idx].getGreen() / 255.0f), (float)((float)this.colors[idx].getBlue() / 255.0f), (float)1.0f);
            this.func_238474_b_(stack, i + 8 + 18 * idx + (idx > 2 ? 34 : 0), j + 13, 172, 32, 16, 16);
            if (idx != this.activeSlot) continue;
            this.func_238474_b_(stack, i + 70, j + 13, 172, 32, 16, 16);
        }
        this.renderBg(stack, partialTicks, x, y);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(stack, i + 8 + 18 * this.activeSlot + (this.activeSlot > 2 ? 34 : 0), j + 13, 172, 16, 16, 16);
        RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        stack.func_227861_a_((double)(j + 32), (double)(-i - 137), 0.0);
        this.func_238468_a_(stack, 0, 0, 128, 128, this.colorMapColor.getRGB(), -1);
        stack.func_227865_b_();
        this.func_238468_a_(stack, i + 9, j + 32, i + 9 + 128, j + 32 + 128, 0, -16777216);
        if (this.huePos >= 0) {
            this.func_238474_b_(stack, i + 141 - 1, this.huePos + this.topPos - 1, 156, 48, 8, 4);
        }
        if (this.colorPos[0] >= 0) {
            this.func_238474_b_(stack, this.leftPos + this.colorPos[0] - 2, this.topPos + this.colorPos[1] - 2, 172, 48, 4, 4);
        }
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        stack.func_227861_a_((double)j, (double)(-i - 167), 0.0);
        if (this.renderColorText) {
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("gui.nekoration.message.color_info", new Object[]{this.colors[this.activeSlot].getRGB(), this.colors[this.activeSlot].getRed(), this.colors[this.activeSlot].getGreen(), this.colors[this.activeSlot].getBlue()}), 1.0f, 1.0f, this.colors[this.activeSlot].getRGB());
        } else {
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)this.tipMessage, 1.0f, 1.0f, -1761607681);
        }
    }

    protected void renderBg(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int edgeSpacingX = (this.field_230708_k_ - this.imageWidth) / 2;
        int edgeSpacingY = (this.field_230709_l_ - this.imageHeight) / 2;
        this.func_238474_b_(stack, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean func_231044_a_(double x, double y, int type) {
        if (type == 0 && !this.updateActiveSlot(x, y)) {
            if (this.isOnColorMap(x, y)) {
                this.getColor(x, y);
            }
            if (this.isOnHuePicker(x, y)) {
                this.getHue(x, y);
            }
        }
        return super.func_231044_a_(x, y, type);
    }

    public boolean func_231045_a_(double x, double y, int type, double dx, double dy) {
        if (type == 0) {
            if (this.isOnColorMap(x, y)) {
                this.getColor(x, y);
            }
            if (this.isOnHuePicker(x, y)) {
                this.getHue(x, y);
            }
        }
        return super.func_231045_a_(x, y, type, dx, dy);
    }

    private boolean isOnColorMap(double x, double y) {
        double dx = x - (double)this.leftPos - 9.0;
        double dy = y - (double)this.topPos - 32.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 128.0 && dy <= 128.0;
    }

    private boolean updateActiveSlot(double x, double y) {
        for (byte idx = 0; idx < 6; ++idx) {
            int l = this.leftPos + 8 + 18 * idx + (idx > 2 ? 34 : 0);
            int r = l + 16;
            int t = this.topPos + 13;
            int b = t + 16;
            if (!(x >= (double)l) || !(x <= (double)r) || !(y >= (double)t) || !(y <= (double)b) || this.activeSlot == idx) continue;
            this.activeSlot = idx;
            Color nw = this.colors[idx];
            float[] fl = Color.RGBtoHSB(nw.getRed(), nw.getGreen(), nw.getBlue(), null);
            this.huePos = 32 + (int)((1.0f - fl[0]) * 128.0f);
            this.colorMapColor = Color.getHSBColor(fl[0], 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void getColor(double x, double y) {
        double xi = (x - (double)this.leftPos - 9.0) / 128.0;
        double yi = (y - (double)this.topPos - 32.0) / 128.0;
        if (xi >= 0.0 && xi <= 1.0 && yi >= 0.0 && yi <= 1.0) {
            Color c1 = NekoColors.getRGBColorBetween(xi, Color.WHITE, this.colorMapColor);
            if (this.activeSlot >= 0 && this.activeSlot < this.colors.length) {
                this.colors[this.activeSlot] = NekoColors.getRGBColorBetween(yi, c1, Color.BLACK);
                this.colorPos[0] = (int)x - this.leftPos;
                this.colorPos[1] = (int)y - this.topPos;
            }
        }
    }

    private void updateColor() {
        double xi = (double)(this.colorPos[0] - 9) / 128.0;
        double yi = (double)(this.colorPos[1] - 32) / 128.0;
        if (xi >= 0.0 && xi <= 1.0 && yi >= 0.0 && yi <= 1.0) {
            Color c1 = NekoColors.getRGBColorBetween(xi, Color.WHITE, this.colorMapColor);
            if (this.activeSlot >= 0 && this.activeSlot < this.colors.length) {
                this.colors[this.activeSlot] = NekoColors.getRGBColorBetween(yi, c1, Color.BLACK);
            }
        }
    }

    private boolean isOnHuePicker(double x, double y) {
        double dx = x - (double)this.leftPos - 141.0;
        double dy = y - (double)this.topPos - 32.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 6.0 && dy <= 128.0;
    }

    private void getHue(double x, double y) {
        double yi = 1.0 - (y - (double)this.topPos - 32.0) / 128.0;
        this.colorMapColor = Color.getHSBColor((float)yi, 1.0f, 1.0f);
        this.updateColor();
        this.huePos = (int)y - this.topPos;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

