/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.client.rendering.RenderTypeHelper;
import com.devbobcorn.nekoration.entities.PaintingData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.Closeable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public abstract class AbstractPaintingRenderer
implements Closeable {
    public abstract void render(MatrixStack var1, Matrix4f var2, Matrix3f var3, IRenderTypeBuffer var4, PaintingData var5, short var6, short var7, float var8, float var9, int var10);

    @Override
    public void close() {
    }

    private static void vertexPixel(Matrix4f pose, Matrix3f normal, IVertexBuilder vertexBuilder, float x, float y, float z, int nx, int ny, int nz, int light, int r, int g, int b) {
        vertexBuilder.func_227888_a_(pose, x, y, z).func_225586_a_(r, g, b, 255).func_227886_a_(light).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
    }

    private static void vertexImage(Matrix4f pose, Matrix3f normal, IVertexBuilder vertexBuilder, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        vertexBuilder.func_227888_a_(pose, x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
    }

    public static class ImagePaintingRenderer
    extends AbstractPaintingRenderer {
        private final DynamicTexture texture;
        protected final RenderType renderType;

        public ImagePaintingRenderer() {
            this.texture = null;
            this.renderType = null;
        }

        public ImagePaintingRenderer(NativeImage nativeImage, TextureManager manager) {
            this.texture = new DynamicTexture(nativeImage);
            this.renderType = RenderTypeHelper.paintingTexture(manager.func_110578_a("painting", this.texture));
        }

        @Override
        public void render(MatrixStack stack, Matrix4f pose, Matrix3f normal, IRenderTypeBuffer buffers, PaintingData data, short blocHor, short blocVer, float left, float bottom, int light) {
            IVertexBuilder vb = buffers.getBuffer(this.renderType);
            short blocHorCount = (short)(data.getWidth() / 16);
            short blocVerCount = (short)(data.getHeight() / 16);
            double d0 = 1.0 / (double)blocHorCount;
            double d1 = 1.0 / (double)blocVerCount;
            float right = left + 16.0f;
            float top = bottom + 16.0f;
            float paintU0 = (float)(d0 * (double)(blocHorCount - blocHor));
            float paintU1 = (float)(d0 * (double)(blocHorCount - (blocHor + 1)));
            float paintV0 = (float)(d1 * (double)(blocVerCount - blocVer));
            float paintV1 = (float)(d1 * (double)(blocVerCount - (blocVer + 1)));
            AbstractPaintingRenderer.vertexImage(pose, normal, vb, right, bottom, paintU1, paintV0, -0.5f, 0, 0, -1, light);
            AbstractPaintingRenderer.vertexImage(pose, normal, vb, left, bottom, paintU0, paintV0, -0.5f, 0, 0, -1, light);
            AbstractPaintingRenderer.vertexImage(pose, normal, vb, left, top, paintU0, paintV1, -0.5f, 0, 0, -1, light);
            AbstractPaintingRenderer.vertexImage(pose, normal, vb, right, top, paintU1, paintV1, -0.5f, 0, 0, -1, light);
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }

    public static class PixelsPaintingRenderer
    extends AbstractPaintingRenderer {
        @Override
        public void render(MatrixStack stack, Matrix4f pose, Matrix3f normal, IRenderTypeBuffer buffers, PaintingData data, short blocHor, short blocVer, float left, float bottom, int light) {
            IVertexBuilder vb = buffers.getBuffer(RenderTypeHelper.paintingPixels());
            for (int posi = 0; posi < 16; posi = (int)((short)(posi + 1))) {
                for (int posj = 0; posj < 16; posj = (int)((short)(posj + 1))) {
                    int[] color = NekoColors.getRGBArray(data.getCompositeAt(data.getWidth() - 1 - (blocHor * 16 + posi), data.getHeight() - 1 - (blocVer * 16 + posj)));
                    AbstractPaintingRenderer.vertexPixel(pose, normal, vb, left + (float)posi + 1.0f, bottom + (float)posj, -0.5f, 0, 0, -1, light, color[0], color[1], color[2]);
                    AbstractPaintingRenderer.vertexPixel(pose, normal, vb, left + (float)posi, bottom + (float)posj, -0.5f, 0, 0, -1, light, color[0], color[1], color[2]);
                    AbstractPaintingRenderer.vertexPixel(pose, normal, vb, left + (float)posi, bottom + (float)posj + 1.0f, -0.5f, 0, 0, -1, light, color[0], color[1], color[2]);
                    AbstractPaintingRenderer.vertexPixel(pose, normal, vb, left + (float)posi + 1.0f, bottom + (float)posj + 1.0f, -0.5f, 0, 0, -1, light, color[0], color[1], color[2]);
                }
            }
        }
    }
}

