/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class QuadRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("nekoration:textures/block/custom.png");

    public static void renderCubeUsingQuads(TileEntity tileEntity, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffers, int combinedLight, int combinedOverlay) {
        Color color = Color.WHITE;
        QuadRenderer.drawCubeQuads(stack, buffers, color, combinedLight);
    }

    private static void drawCubeQuads(MatrixStack stack, IRenderTypeBuffer buffers, Color color, int combinedLight) {
        IVertexBuilder vertexBuilderBlockQuads = buffers.getBuffer(RenderType.func_228634_a_((ResourceLocation)TEXTURE));
        Matrix4f matrixPos = stack.func_227866_c_().func_227870_a_();
        Matrix3f matrixNormal = stack.func_227866_c_().func_227872_b_();
        Vector2f bottomLeftUV = new Vector2f(0.0f, 1.0f);
        float UVwidth = 1.0f;
        float UVheight = 1.0f;
        float WIDTH = 1.0f;
        float HEIGHT = 1.0f;
        Vector3d EAST_FACE_MIDPOINT = new Vector3d(1.0, 0.5, 0.5);
        Vector3d WEST_FACE_MIDPOINT = new Vector3d(0.0, 0.5, 0.5);
        Vector3d NORTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 0.0);
        Vector3d SOUTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 1.0);
        Vector3d UP_FACE_MIDPOINT = new Vector3d(0.5, 1.0, 0.5);
        Vector3d DOWN_FACE_MIDPOINT = new Vector3d(0.5, 0.0, 0.5);
        QuadRenderer.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
    }

    private static void addFace(Direction whichFace, Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder buffers, Color color, Vector3d centrePos, float width, float height, Vector2f bottomLeftUV, float texUwidth, float texVheight, int lightmapValue) {
        Vector3f bottomToTopDirection;
        Vector3f leftToRightDirection;
        switch (whichFace) {
            case NORTH: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case EAST: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case WEST: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case UP: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case DOWN: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
            }
        }
        leftToRightDirection.func_195898_a(0.5f * width);
        bottomToTopDirection.func_195898_a(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f(centrePos);
        bottomLeftPos.func_195897_a(leftToRightDirection);
        bottomLeftPos.func_195897_a(bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f(centrePos);
        bottomRightPos.func_229189_a_(leftToRightDirection);
        bottomRightPos.func_195897_a(bottomToTopDirection);
        Vector3f topRightPos = new Vector3f(centrePos);
        topRightPos.func_229189_a_(leftToRightDirection);
        topRightPos.func_229189_a_(bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f(centrePos);
        topLeftPos.func_195897_a(leftToRightDirection);
        topLeftPos.func_229189_a_(bottomToTopDirection);
        Vector2f bottomLeftUVpos = new Vector2f(bottomLeftUV.field_189982_i, bottomLeftUV.field_189983_j);
        Vector2f bottomRightUVpos = new Vector2f(bottomLeftUV.field_189982_i + texUwidth, bottomLeftUV.field_189983_j);
        Vector2f topLeftUVpos = new Vector2f(bottomLeftUV.field_189982_i + texUwidth, bottomLeftUV.field_189983_j + texVheight);
        Vector2f topRightUVpos = new Vector2f(bottomLeftUV.field_189982_i, bottomLeftUV.field_189983_j + texVheight);
        Vector3f normalVector = whichFace.func_229386_k_();
        QuadRenderer.addQuad(matrixPos, matrixNormal, buffers, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightmapValue);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder buffers, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vector2f blUVpos, Vector2f brUVpos, Vector2f trUVpos, Vector2f tlUVpos, Vector3f normalVector, Color color, int lightmapValue) {
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, blpos, blUVpos, normalVector, color, lightmapValue);
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, brpos, brUVpos, normalVector, color, lightmapValue);
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, trpos, trUVpos, normalVector, color, lightmapValue);
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    private static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder buffers, Vector3f pos, Vector2f texUV, Vector3f normalVector, Color color, int lightmapValue) {
        buffers.func_227888_a_(matrixPos, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_225583_a_(texUV.field_189982_i, texUV.field_189983_j).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmapValue).func_227887_a_(matrixNormal, normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
    }
}

