/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering.entities;

import com.devbobcorn.nekoration.client.rendering.AbstractPaintingRenderer;
import com.devbobcorn.nekoration.client.rendering.PaintingRendererManager;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;

public class PaintingRenderer
extends EntityRenderer<PaintingEntity> {
    public PaintingRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(PaintingEntity entity, float rotation, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffers, int packedLight) {
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotation));
        stack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        PaintingSpriteUploader paintingspriteuploader = Minecraft.func_71410_x().func_213263_ao();
        this.renderPainting(stack, buffers, entity, entity.func_82329_d(), entity.func_82330_g(), paintingspriteuploader.func_215286_b());
        stack.func_227865_b_();
        super.func_225623_a_((Entity)entity, rotation, partialTicks, stack, buffers, packedLight);
    }

    public ResourceLocation getTextureLocation(PaintingEntity entity) {
        return Minecraft.func_71410_x().func_213263_ao().func_215286_b().func_229241_m_().func_229223_g_();
    }

    private void renderPainting(MatrixStack stack, IRenderTypeBuffer buffers, PaintingEntity entity, int width, int height, TextureAtlasSprite woodTex) {
        MatrixStack.Entry matrixstack$entry = stack.func_227866_c_();
        Matrix4f pose = matrixstack$entry.func_227870_a_();
        Matrix3f normal = matrixstack$entry.func_227872_b_();
        float LEFT = (float)(-width) / 2.0f;
        float TOP = (float)(-height) / 2.0f;
        float woodU0 = woodTex.func_94209_e();
        float woodU1 = woodTex.func_94212_f();
        float woodV0 = woodTex.func_94206_g();
        float woodV1 = woodTex.func_94210_h();
        float woodV_ = woodTex.func_94207_b(1.0);
        float woodU_ = woodTex.func_94214_a(1.0);
        short blocHorCount = (short)(width / 16);
        short blocVerCount = (short)(height / 16);
        for (short blocHor = 0; blocHor < blocHorCount; blocHor = (short)(blocHor + 1)) {
            for (short blocVer = 0; blocVer < blocVerCount; blocVer = (short)(blocVer + 1)) {
                IVertexBuilder vb1 = buffers.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getTextureLocation(entity)));
                float right = LEFT + (float)((blocHor + 1) * 16);
                float left = LEFT + (float)(blocHor * 16);
                float top = TOP + (float)((blocVer + 1) * 16);
                float bottom = TOP + (float)(blocVer * 16);
                int blocx = MathHelper.func_76128_c((double)entity.func_226277_ct_());
                int blocy = MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)((top + bottom) / 2.0f / 16.0f)));
                int blocz = MathHelper.func_76128_c((double)entity.func_226281_cx_());
                Direction direction = entity.func_174811_aO();
                if (direction == Direction.NORTH) {
                    blocx = MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)((right + left) / 2.0f / 16.0f)));
                }
                if (direction == Direction.WEST) {
                    blocz = MathHelper.func_76128_c((double)(entity.func_226281_cx_() - (double)((right + left) / 2.0f / 16.0f)));
                }
                if (direction == Direction.SOUTH) {
                    blocx = MathHelper.func_76128_c((double)(entity.func_226277_ct_() - (double)((right + left) / 2.0f / 16.0f)));
                }
                if (direction == Direction.EAST) {
                    blocz = MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)((right + left) / 2.0f / 16.0f)));
                }
                int light = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)new BlockPos(blocx, blocy, blocz));
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, top, woodU0, woodV0, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, top, woodU1, woodV0, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, bottom, woodU1, woodV1, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, bottom, woodU0, woodV1, 0.5f, 0, 0, 1, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, top, woodU0, woodV0, -0.5f, 0, 1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, top, woodU1, woodV0, -0.5f, 0, 1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, top, woodU1, woodV_, 0.5f, 0, 1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, top, woodU0, woodV_, 0.5f, 0, 1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, bottom, woodU0, woodV0, 0.5f, 0, -1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, bottom, woodU1, woodV0, 0.5f, 0, -1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, bottom, woodU1, woodV_, -0.5f, 0, -1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, bottom, woodU0, woodV_, -0.5f, 0, -1, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, top, woodU_, woodV0, 0.5f, -1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, bottom, woodU_, woodV1, 0.5f, -1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, bottom, woodU0, woodV1, -0.5f, -1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, right, top, woodU0, woodV0, -0.5f, -1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, top, woodU_, woodV0, -0.5f, 1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, bottom, woodU_, woodV1, -0.5f, 1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, bottom, woodU0, woodV1, 0.5f, 1, 0, 0, light);
                PaintingRenderer.vertexFrame(pose, normal, vb1, left, top, woodU0, woodV0, 0.5f, 1, 0, 0, light);
                AbstractPaintingRenderer rd = null;
                if (entity.data.imageReady) {
                    rd = PaintingRendererManager.get(entity.data.getPaintingHash());
                    if (rd == null) {
                        System.err.println("Image Renderer Not Ready!");
                        entity.data.imageReady = false;
                        rd = PaintingRendererManager.PixelsRenderer();
                    }
                } else {
                    rd = PaintingRendererManager.PixelsRenderer();
                }
                ((AbstractPaintingRenderer)rd).render(stack, pose, normal, buffers, entity.data, blocHor, blocVer, left, bottom, light);
                stack.func_227860_a_();
                stack.func_227861_a_((double)(-LEFT) - 1.0, (double)TOP + 3.0, -0.6);
                stack.func_227862_a_(-0.2f, -0.2f, 0.2f);
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, entity.data.imageReady ? "Rendered with Image" : "Rendered Pixel-by-Pixel", 1.0f, 1.0f, 0xFFFFFF);
                stack.func_227861_a_(0.0, -10.0, 0.0);
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(stack, "#" + String.valueOf(entity.data.getPaintingHash()), 1.0f, 1.0f, 0xFFFFFF);
                stack.func_227865_b_();
            }
        }
    }

    private static void vertexFrame(Matrix4f pose, Matrix3f normal, IVertexBuilder vertexBuilder, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        vertexBuilder.func_227888_a_(pose, x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
    }
}

