/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.common.event;

import com.devbobcorn.nekoration.blocks.CandleHolderBlock;
import com.devbobcorn.nekoration.blocks.ChairBlock;
import com.devbobcorn.nekoration.blocks.DyeableBlock;
import com.devbobcorn.nekoration.blocks.DyeableDoorBlock;
import com.devbobcorn.nekoration.blocks.DyeableHorizontalBlock;
import com.devbobcorn.nekoration.blocks.DyeableHorizontalConnectBlock;
import com.devbobcorn.nekoration.blocks.EaselMenuBlock;
import com.devbobcorn.nekoration.blocks.HalfTimberBlock;
import com.devbobcorn.nekoration.blocks.HalfTimberPillarBlock;
import com.devbobcorn.nekoration.blocks.ModBlocks;
import com.devbobcorn.nekoration.blocks.StoneBlock;
import com.devbobcorn.nekoration.blocks.StonePillarBlock;
import com.devbobcorn.nekoration.blocks.TableBlock;
import com.devbobcorn.nekoration.blocks.WindowBlock;
import com.devbobcorn.nekoration.common.VanillaCompat;
import com.devbobcorn.nekoration.items.DyeableBlockItem;
import com.devbobcorn.nekoration.items.DyeableWoodenBlockItem;
import com.devbobcorn.nekoration.items.HalfTimberBlockItem;
import com.devbobcorn.nekoration.items.ModItemTabs;
import com.devbobcorn.nekoration.particles.FlameParticleType;
import com.devbobcorn.nekoration.particles.ModParticles;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="nekoration", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"nekoration Mod Event Subscriber");

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            BlockItem blockItem;
            if (block instanceof TableBlock || block instanceof ChairBlock) {
                Item.Properties properties = new Item.Properties().func_200916_a(ModItemTabs.FURNITURE_GROUP);
                blockItem = new BlockItem(block, properties);
            } else if (block instanceof HalfTimberBlock || block instanceof HalfTimberPillarBlock) {
                Item.Properties properties = new Item.Properties().func_200916_a(ModItemTabs.WOODEN_GROUP);
                blockItem = new HalfTimberBlockItem((Block)block, properties);
            } else if (block instanceof WindowBlock || block instanceof EaselMenuBlock) {
                Item.Properties properties = new Item.Properties().func_200916_a(block instanceof WindowBlock ? ModItemTabs.WINDOW_N_DOOR_GROUP : ModItemTabs.DECOR_GROUP);
                blockItem = new DyeableWoodenBlockItem((Block)block, properties);
            } else if (block instanceof StoneBlock || block instanceof StonePillarBlock) {
                Item.Properties properties = new Item.Properties().func_200916_a(ModItemTabs.STONE_GROUP);
                blockItem = new DyeableBlockItem((Block)block, properties);
            } else if (block instanceof DyeableBlock || block instanceof DyeableHorizontalConnectBlock) {
                if (block instanceof CandleHolderBlock) {
                    Item.Properties properties = new Item.Properties().func_200916_a(ModItemTabs.DECOR_GROUP);
                    blockItem = new DyeableBlockItem((Block)block, properties, false);
                } else {
                    Item.Properties properties = block instanceof DyeableHorizontalBlock ? (block instanceof DyeableHorizontalConnectBlock ? new Item.Properties().func_200916_a(ModItemTabs.WINDOW_N_DOOR_GROUP) : new Item.Properties().func_200916_a(ModItemTabs.DECOR_GROUP)) : new Item.Properties().func_200916_a(ModItemTabs.DECOR_GROUP);
                    blockItem = new DyeableBlockItem((Block)block, properties);
                }
            } else {
                Item.Properties properties = block instanceof DyeableDoorBlock ? new Item.Properties().func_200916_a(ModItemTabs.WINDOW_N_DOOR_GROUP) : new Item.Properties().func_200916_a(ModItemTabs.DECOR_GROUP);
                blockItem = new BlockItem(block, properties);
            }
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
        LOGGER.info("BlockItems Registered.");
    }

    @SubscribeEvent
    public static void onRegisterIParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        ModParticles.FLAME = new FlameParticleType();
        ModParticles.FLAME.setRegistryName("nekoration", "flame");
        event.getRegistry().register(ModParticles.FLAME);
    }

    @SubscribeEvent
    public static void onFMLCommonSetupEvent(FMLCommonSetupEvent event) {
        VanillaCompat.Initialize();
    }
}

