/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.debug;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.debug.DebugSettings;
import com.devbobcorn.nekoration.exp.ExpNBTTypes;
import com.devbobcorn.nekoration.items.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.lang.reflect.Field;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugBlockVoxelShapeHighlighter {
    public static final String Param1 = "showshape";
    public static final String Param2 = "showrendershape";
    public static final String Param3 = "showcollisionshape";
    public static final String Param4 = "showraytraceshape";
    public static boolean HoldingPalette = false;
    public static Color PaletteColor = Color.RED;
    private static Field worldField;
    private static boolean loggedReflectionError;
    private static final Logger LOGGER;

    @SubscribeEvent
    public static void onDrawBlockHighlightEvent(DrawHighlightEvent.HighlightBlock event) {
        VoxelShape shape;
        boolean showraytraceshape;
        World world;
        BlockRayTraceResult rayTraceResult = event.getTarget();
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        try {
            world = DebugBlockVoxelShapeHighlighter.getPrivateWorldFromWorldRenderer(event.getContext());
        }
        catch (IllegalAccessException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            if (!loggedReflectionError) {
                LOGGER.error("Could not find WorldRenderer.world");
            }
            loggedReflectionError = true;
            return;
        }
        BlockPos blockpos = rayTraceResult.func_216350_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.isAir((IBlockReader)world, blockpos) || !world.func_175723_af().func_177746_a(blockpos)) {
            return;
        }
        ItemStack itemStack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (itemStack.func_77973_b() == ModItems.PALETTE.get()) {
            if (!HoldingPalette) {
                CompoundNBT nbt = itemStack.func_77978_p();
                if (nbt != null && nbt.func_150297_b("active", (int)ExpNBTTypes.BYTE_NBT_ID)) {
                    byte a = nbt.func_74771_c("active");
                    int[] c = nbt.func_74759_k("colors");
                    PaletteColor = NekoColors.getRGBColor(c[a]);
                    return;
                }
                HoldingPalette = true;
            }
            ActiveRenderInfo ari = event.getInfo();
            VoxelShape shape2 = blockstate.func_215700_a((IBlockReader)world, blockpos, ISelectionContext.func_216374_a((Entity)ari.func_216773_g()));
            DebugBlockVoxelShapeHighlighter.drawSelectionBox(event.getContext(), event.getBuffers(), event.getMatrix(), blockpos, ari, shape2, PaletteColor);
        } else if (HoldingPalette) {
            HoldingPalette = false;
        }
        boolean showshape = DebugSettings.getDebugParameter(Param1).isPresent() || DebugSettings.getDebugParameterVec3d(Param1).isPresent();
        boolean showrendershape = DebugSettings.getDebugParameter(Param2).isPresent() || DebugSettings.getDebugParameterVec3d(Param2).isPresent();
        boolean showcollisionshape = DebugSettings.getDebugParameter(Param3).isPresent() || DebugSettings.getDebugParameterVec3d(Param3).isPresent();
        boolean bl = showraytraceshape = DebugSettings.getDebugParameter(Param4).isPresent() || DebugSettings.getDebugParameterVec3d(Param4).isPresent();
        if (!(showshape || showrendershape || showcollisionshape || showraytraceshape)) {
            return;
        }
        ActiveRenderInfo activeRenderInfo = event.getInfo();
        ISelectionContext iSelectionContext = ISelectionContext.func_216374_a((Entity)activeRenderInfo.func_216773_g());
        IRenderTypeBuffer renderTypeBuffers = event.getBuffers();
        MatrixStack matrixStack = event.getMatrix();
        if (showshape) {
            Color SHAPE_COLOR = DebugSettings.getDebugParameterVec3d(Param1).isPresent() ? NekoColors.getRGBColor(DebugSettings.getDebugParameterVec3d(Param1).get()) : NekoColors.getRGBColor(DebugSettings.getDebugParameter(Param1).get());
            shape = blockstate.func_215700_a((IBlockReader)world, blockpos, iSelectionContext);
            DebugBlockVoxelShapeHighlighter.drawSelectionBox(event.getContext(), renderTypeBuffers, matrixStack, blockpos, activeRenderInfo, shape, SHAPE_COLOR);
        }
        if (showrendershape) {
            Color RENDERSHAPE_COLOR = DebugSettings.getDebugParameterVec3d(Param2).isPresent() ? NekoColors.getRGBColor(DebugSettings.getDebugParameterVec3d(Param2).get()) : NekoColors.getRGBColor(DebugSettings.getDebugParameter(Param2).get());
            shape = blockstate.func_196954_c((IBlockReader)world, blockpos);
            DebugBlockVoxelShapeHighlighter.drawSelectionBox(event.getContext(), renderTypeBuffers, matrixStack, blockpos, activeRenderInfo, shape, RENDERSHAPE_COLOR);
        }
        if (showcollisionshape) {
            Color COLLISIONSHAPE_COLOR = DebugSettings.getDebugParameterVec3d(Param3).isPresent() ? NekoColors.getRGBColor(DebugSettings.getDebugParameterVec3d(Param3).get()) : NekoColors.getRGBColor(DebugSettings.getDebugParameter(Param3).get());
            shape = blockstate.func_215685_b((IBlockReader)world, blockpos, iSelectionContext);
            DebugBlockVoxelShapeHighlighter.drawSelectionBox(event.getContext(), renderTypeBuffers, matrixStack, blockpos, activeRenderInfo, shape, COLLISIONSHAPE_COLOR);
        }
        if (showraytraceshape) {
            Color RAYTRACESHAPE_COLOR = DebugSettings.getDebugParameterVec3d(Param4).isPresent() ? NekoColors.getRGBColor(DebugSettings.getDebugParameterVec3d(Param4).get()) : NekoColors.getRGBColor(DebugSettings.getDebugParameter(Param4).get());
            shape = blockstate.func_199611_f((IBlockReader)world, blockpos, iSelectionContext);
            DebugBlockVoxelShapeHighlighter.drawSelectionBox(event.getContext(), renderTypeBuffers, matrixStack, blockpos, activeRenderInfo, shape, RAYTRACESHAPE_COLOR);
        }
        event.setCanceled(true);
    }

    private static World getPrivateWorldFromWorldRenderer(WorldRenderer worldRenderer) throws IllegalAccessException, ObfuscationReflectionHelper.UnableToFindFieldException {
        if (worldField == null) {
            worldField = ObfuscationReflectionHelper.findField(WorldRenderer.class, (String)"field_72769_h");
        }
        return (World)worldField.get(worldRenderer);
    }

    private static void drawSelectionBox(WorldRenderer worldRenderer, IRenderTypeBuffer renderTypeBuffers, MatrixStack matrixStack, BlockPos blockPos, ActiveRenderInfo activeRenderInfo, VoxelShape shape, Color color) {
        RenderType renderType = RenderType.func_228659_m_();
        IVertexBuilder vertexBuilder = renderTypeBuffers.getBuffer(renderType);
        double eyeX = activeRenderInfo.func_216785_c().func_82615_a();
        double eyeY = activeRenderInfo.func_216785_c().func_82617_b();
        double eyeZ = activeRenderInfo.func_216785_c().func_82616_c();
        float ALPHA = 0.5f;
        DebugBlockVoxelShapeHighlighter.drawShapeOutline(matrixStack, vertexBuilder, shape, (double)blockPos.func_177958_n() - eyeX, (double)blockPos.func_177956_o() - eyeY, (double)blockPos.func_177952_p() - eyeZ, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
    }

    private static void drawShapeOutline(MatrixStack matrixStack, IVertexBuilder vertexBuilder, VoxelShape voxelShape, double originX, double originY, double originZ, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        voxelShape.func_197754_a((x0, y0, z0, x1, y1, z1) -> {
            vertexBuilder.func_227888_a_(matrix4f, (float)(x0 + originX), (float)(y0 + originY), (float)(z0 + originZ)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            vertexBuilder.func_227888_a_(matrix4f, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }

    static {
        loggedReflectionError = false;
        LOGGER = LogManager.getLogger();
    }
}

