/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.debug;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.math.vector.Vector3d;

public class DebugSettings {
    private static HashMap<String, Optional<Double>> debugParameters = new HashMap();
    private static HashMap<String, Optional<Vector3d>> debugParameterVec3ds = new HashMap();
    private static HashMap<String, Boolean> debugTriggers = new HashMap();
    public static final int NO_TEST_TRIGGERED = -1;
    private static int debugTest = -1;

    public static synchronized void setDebugParameter(String parameterName, double value) {
        debugParameters.put(parameterName, Optional.of(value));
    }

    public static synchronized void clearDebugParameter(String parameterName) {
        debugParameters.put(parameterName, Optional.empty());
    }

    public static synchronized Optional<Double> getDebugParameter(String parameterName) {
        Optional<Double> value = debugParameters.get(parameterName);
        if (value == null) {
            debugParameters.put(parameterName, Optional.empty());
            return Optional.empty();
        }
        return value;
    }

    public static synchronized Set<String> listAllDebugParameters() {
        return debugParameters.keySet();
    }

    public static synchronized void setDebugParameterVec3d(String parameterName, Vector3d value) {
        debugParameterVec3ds.put(parameterName, Optional.of(value));
    }

    public static synchronized void clearDebugParameterVec3d(String parameterName) {
        debugParameterVec3ds.put(parameterName, Optional.empty());
    }

    public static synchronized Optional<Vector3d> getDebugParameterVec3d(String parameterName) {
        Optional<Vector3d> value = debugParameterVec3ds.get(parameterName);
        if (value == null) {
            debugParameterVec3ds.put(parameterName, Optional.empty());
            return Optional.empty();
        }
        return value;
    }

    public static synchronized Set<String> listAllDebugParameterVec3ds() {
        return debugParameterVec3ds.keySet();
    }

    public static synchronized void setDebugTrigger(String parameterName) {
        debugTriggers.put(parameterName, true);
    }

    public static synchronized boolean getDebugTrigger(String parameterName) {
        Boolean value = debugTriggers.getOrDefault(parameterName, false);
        debugTriggers.put(parameterName, false);
        return value;
    }

    public static synchronized Set<String> listAllDebugTriggers() {
        return debugTriggers.keySet();
    }

    public static synchronized void setDebugTest(int testnumber) {
        debugTest = testnumber;
    }

    public static synchronized int getDebugTest(int testNumberMin, int testNumberMaxPlusOne) {
        if (debugTest < testNumberMin || debugTest >= testNumberMaxPlusOne) {
            return -1;
        }
        int value = debugTest;
        debugTest = -1;
        return value;
    }
}

