/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.debug;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class MethodCallLogger {
    private ConcurrentHashMap<String, Boolean> shouldLogMap = new ConcurrentHashMap();
    private boolean immediateOutput = false;
    private boolean shouldLogClient = true;
    private boolean shouldLogServer = true;
    private HashMap<String, Boolean> reentryFlagsClient = new HashMap();
    private HashMap<String, Boolean> reentryFlagsServer = new HashMap();
    private int indentLevelClient = 0;
    private int indentLevelServer = 0;
    private PrintStream printStream;
    private static final int INITIAL_STRING_CAPACITY = 1000;
    private StringBuilder outputBufferClient = new StringBuilder(1000);
    private StringBuilder outputBufferServer = new StringBuilder(1000);
    private static final String CRLF = System.getProperty("line.separator");
    private static final String INDENT_STRING = "                                                            ";
    private static final int SPACES_PER_INDENT = 2;
    private LogicalSide forcedSideForTesting = null;

    public MethodCallLogger() {
        this(System.out);
    }

    public MethodCallLogger(PrintStream stream) {
        this.printStream = stream;
    }

    public void enterMethod(String methodName, String parameters) {
        int indentLevel;
        if (!this.shouldLog(methodName)) {
            return;
        }
        LogicalSide side = this.forcedSideForTesting != null ? this.forcedSideForTesting : EffectiveSide.get();
        HashMap<String, Boolean> reentryFlagsSide = side == LogicalSide.CLIENT ? this.reentryFlagsClient : this.reentryFlagsServer;
        int n = indentLevel = side == LogicalSide.CLIENT ? this.indentLevelClient : this.indentLevelServer;
        if (reentryFlagsSide.containsKey(methodName) && reentryFlagsSide.get(methodName).booleanValue()) {
            String errorMessage = "!! Re-entry into " + methodName + "(" + parameters + ")";
            this.addIndentedOutputLine(side, indentLevel, errorMessage, false);
            errorMessage = "!!Further logging of " + methodName + " disabled!!";
            if (side == LogicalSide.CLIENT) {
                --this.indentLevelClient;
            } else {
                --this.indentLevelServer;
            }
            this.addIndentedOutputLine(side, indentLevel, errorMessage, indentLevel == 0 || this.immediateOutput);
            this.setShouldLog(methodName, false);
            return;
        }
        reentryFlagsSide.put(methodName, true);
        this.addIndentedOutputLine(side, indentLevel, methodName + "(" + parameters + ") {", this.immediateOutput);
        if (side == LogicalSide.CLIENT) {
            ++this.indentLevelClient;
        } else {
            ++this.indentLevelServer;
        }
    }

    public void exitMethod(String methodName, String returnValue) {
        int indentLevel;
        if (!this.shouldLog(methodName)) {
            return;
        }
        LogicalSide side = this.forcedSideForTesting != null ? this.forcedSideForTesting : EffectiveSide.get();
        HashMap<String, Boolean> reentryFlagsSide = side == LogicalSide.CLIENT ? this.reentryFlagsClient : this.reentryFlagsServer;
        int n = indentLevel = side == LogicalSide.CLIENT ? this.indentLevelClient : this.indentLevelServer;
        if (!reentryFlagsSide.containsKey(methodName) || !reentryFlagsSide.get(methodName).booleanValue()) {
            return;
        }
        reentryFlagsSide.put(methodName, false);
        if (side == LogicalSide.CLIENT) {
            --this.indentLevelClient;
            if (this.indentLevelClient < 0) {
                this.indentLevelClient = 0;
            }
        } else {
            --this.indentLevelServer;
            if (this.indentLevelServer < 0) {
                this.indentLevelServer = 0;
            }
        }
        this.addIndentedOutputLine(side, indentLevel - 1, "} " + methodName + " return=" + returnValue, indentLevel <= 1 || this.immediateOutput);
    }

    public void setShouldLog(String methodName, boolean shouldLog) {
        this.shouldLogMap.put(methodName, shouldLog);
    }

    public void setSideLogging(LogicalSide side, boolean shouldLog) {
        if (side == LogicalSide.CLIENT) {
            this.shouldLogClient = shouldLog;
        } else if (side == LogicalSide.SERVER) {
            this.shouldLogServer = shouldLog;
        } else {
            System.out.println("Illegal side :" + side);
        }
    }

    public void setImmediateOutput(boolean outputIsImmediate) {
        this.immediateOutput = outputIsImmediate;
    }

    public boolean shouldLog(String methodName) {
        LogicalSide side;
        LogicalSide logicalSide = side = this.forcedSideForTesting != null ? this.forcedSideForTesting : EffectiveSide.get();
        if (side == LogicalSide.SERVER ? !this.shouldLogServer : side == LogicalSide.CLIENT && !this.shouldLogClient) {
            return false;
        }
        if (!this.shouldLogMap.containsKey(methodName)) {
            return true;
        }
        return this.shouldLogMap.get(methodName);
    }

    public void addOutputLine(LogicalSide side, String outputToAdd, boolean flushImmediately) {
        StringBuilder outputBuffer = side == LogicalSide.CLIENT ? this.outputBufferClient : this.outputBufferServer;
        outputBuffer.append(outputToAdd);
        outputBuffer.append(CRLF);
        if (flushImmediately) {
            this.printStream.print(outputBuffer);
            outputBuffer.setLength(0);
        }
    }

    private void addIndentedOutputLine(LogicalSide side, int indentLevel, String outputToAdd, boolean flushImmediately) {
        StringBuilder outputBuffer = side == LogicalSide.CLIENT ? this.outputBufferClient : this.outputBufferServer;
        String sideSymbol = side == LogicalSide.CLIENT ? "C: " : "S: ";
        outputBuffer.append(sideSymbol);
        int endIndex = indentLevel * 2;
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex > INDENT_STRING.length()) {
            endIndex = INDENT_STRING.length();
        }
        outputBuffer.append(INDENT_STRING.substring(0, endIndex));
        this.addOutputLine(side, outputToAdd, flushImmediately);
    }

    public static void test() {
        MethodCallLogger logger = new MethodCallLogger();
        String NAME1 = "method1";
        String NAME2 = "method2";
        String NAME3 = "method3";
        System.out.println("MethodCallLogger test start");
        System.out.println("Test1");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.enterMethod("method1", "param1");
        logger.enterMethod("method2", "param2");
        logger.enterMethod("method3", "3");
        logger.exitMethod("method3", "retval3");
        logger.exitMethod("method2", "retval2");
        logger.enterMethod("method3", "");
        logger.exitMethod("method3", "");
        logger.exitMethod("method1", "retval1");
        logger = new MethodCallLogger();
        System.out.println("Test2");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.setShouldLog("method2", false);
        logger.enterMethod("method1", "param1");
        logger.enterMethod("method2", "param2");
        logger.enterMethod("method3", "3");
        logger.exitMethod("method3", "retval3");
        logger.exitMethod("method2", "retval2");
        logger.enterMethod("method3", "");
        logger.exitMethod("method3", "");
        logger.exitMethod("method1", "retval1");
        logger = new MethodCallLogger();
        System.out.println("Test3");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.setSideLogging(LogicalSide.SERVER, false);
        logger.enterMethod("method1", "param1");
        logger.enterMethod("method2", "param2");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.enterMethod("method3", "3");
        logger.exitMethod("method3", "retval3");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.exitMethod("method2", "retval2");
        logger.enterMethod("method3", "");
        logger.exitMethod("method3", "");
        logger.exitMethod("method1", "retval1");
        logger = new MethodCallLogger();
        System.out.println("Test4");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.enterMethod("method1", "param1");
        logger.enterMethod("method2", "param2");
        logger.enterMethod("method2", "param2");
        logger.enterMethod("method3", "param3");
        logger.enterMethod("method2", "param2");
        logger.exitMethod("method2", "retval2");
        logger.exitMethod("method3", "retval3");
        logger.exitMethod("method2", "retval2");
        logger.exitMethod("method2", "retval2");
        logger.enterMethod("method3", "");
        logger.exitMethod("method3", "");
        logger.exitMethod("method1", "retval1");
        logger = new MethodCallLogger();
        System.out.println("Test5");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.enterMethod("method1", "param1");
        logger.enterMethod("method2", "param2");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.enterMethod("method2", "Server1st");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.enterMethod("method3", "3");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.exitMethod("method2", "Server1stExit");
        logger.enterMethod("method3", "serverside");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.exitMethod("method3", "retval3");
        logger.exitMethod("method2", "retval2");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.exitMethod("method3", "serverside");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.exitMethod("method1", "retval1");
        logger = new MethodCallLogger();
        System.out.println("Test6");
        logger.setImmediateOutput(true);
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.enterMethod("method1", "param1");
        logger.enterMethod("method2", "param2");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.enterMethod("method2", "Server1st");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.enterMethod("method3", "3");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.exitMethod("method2", "Server1stExit");
        logger.enterMethod("method3", "serverside");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.exitMethod("method3", "retval3");
        logger.exitMethod("method2", "retval2");
        logger.forcedSideForTesting = LogicalSide.SERVER;
        logger.exitMethod("method3", "serverside");
        logger.forcedSideForTesting = LogicalSide.CLIENT;
        logger.exitMethod("method1", "retval1");
        System.out.println("MethodCallLogger test complete");
    }
}

