/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.entities;

import com.devbobcorn.nekoration.NekoColors;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class PaintingData {
    private short width;
    private short height;
    private int seed;
    public final boolean isClient;
    private int[] canvas;
    private int[] pixels;
    private int[] composite;
    private int paintingHash;
    public boolean imageReady = false;
    private static final String CACHE_PATH = "nekocache";

    public PaintingData(short w, short h, boolean client, int seed) {
        this.width = w;
        this.height = h;
        this.pixels = new int[w * h];
        this.seed = seed;
        this.isClient = client;
        if (this.isClient) {
            Random random = new Random(seed);
            this.canvas = new int[w * h];
            this.composite = new int[w * h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int n = i % 16 == 0 || j % 16 == 0 ? 12230784 : 15390384;
                    this.canvas[i + j * w] = n;
                    this.composite[i + j * w] = n;
                }
            }
            int bottom = (h - 1) * w;
            int right = w - 1;
            for (int i = 0; i < w; ++i) {
                this.composite[i] = this.canvas[i] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                int n = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[i + bottom] = n;
                this.composite[i + bottom] = n;
            }
            for (int j = 1; j < h - 1; ++j) {
                int n = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[j * w] = n;
                this.composite[j * w] = n;
                int n2 = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[right + j * w] = n2;
                this.composite[right + j * w] = n2;
            }
            this.updatePaintingHash();
            this.cache();
        }
    }

    public PaintingData(short w, short h, int[] pix, boolean client, int seed) {
        this.width = w;
        this.height = h;
        this.pixels = pix;
        this.seed = seed;
        this.isClient = client;
        if (this.isClient) {
            Random random = new Random(seed);
            this.canvas = new int[w * h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    this.canvas[i + j * w] = i % 16 == 0 || j % 16 == 0 ? 12230784 : 15390384;
                }
            }
            int bottom = (h - 1) * w;
            int right = w - 1;
            for (int i = 0; i < w; ++i) {
                this.canvas[i] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[i + bottom] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
            }
            for (int j = 1; j < h - 1; ++j) {
                this.canvas[j * w] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
                this.canvas[right + j * w] = (172 + random.nextInt(30) << 16) + (116 + random.nextInt(30) << 8) + 38 + random.nextInt(18);
            }
            this.composite = new int[w * h];
            this.recalculateComposite();
            this.updatePaintingHash();
            this.imageReady = this.cache();
        }
    }

    public boolean cache() {
        File fileCheck;
        Minecraft minecraft = Minecraft.func_71410_x();
        File pathCheck = new File(minecraft.field_71412_D, CACHE_PATH);
        if (pathCheck.isDirectory() && (fileCheck = new File(pathCheck, this.getPaintingHash() + ".png")).exists()) {
            System.out.println("Image #" + this.getPaintingHash() + " already cached.");
            return true;
        }
        return this.save(CACHE_PATH, String.valueOf(this.getPaintingHash()), true, false);
    }

    public boolean save(String path, String name, boolean composite, boolean showMessage) {
        try {
            Minecraft minecraft = Minecraft.func_71410_x();
            BufferedImage image = new BufferedImage(this.width, this.height, 2);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    image.setRGB(i, j, composite ? -16777216 + this.getCompositeAt(i, j) : this.getPixelAt(i, j));
                }
            }
            File file = new File(minecraft.field_71412_D, path);
            if (!file.exists() && !file.mkdir()) {
                throw new IOException("Could not create folder");
            }
            File finalFile = new File(file, name + ".png");
            System.out.println("Image cached to " + finalFile.getAbsolutePath());
            if (!ImageIO.write((RenderedImage)image, "png", finalFile)) {
                throw new IOException("Could not encode image as png!");
            }
            if (showMessage) {
                StringTextComponent component = new StringTextComponent(finalFile.getName());
                component = component.func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, finalFile.getAbsolutePath())));
                minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("gui.nekoration.message." + (composite ? "painting_saved" : "painting_content_saved"), new Object[]{component}), false);
            }
            this.imageReady = true;
            return true;
        }
        catch (IOException e) {
            this.imageReady = false;
            return false;
        }
    }

    public boolean clearCache(int target) {
        File file;
        Minecraft minecraft = Minecraft.func_71410_x();
        File path = new File(minecraft.field_71412_D, CACHE_PATH);
        if (path.isDirectory() && (file = new File(path, target + ".png")).delete()) {
            System.out.println("Image #" + target + " cache cleared.");
            return true;
        }
        return false;
    }

    private void updatePaintingHash() {
        this.paintingHash = Arrays.hashCode(this.composite);
    }

    public int getPaintingHash() {
        return this.paintingHash;
    }

    public static void writeTo(PaintingData data, CompoundNBT tag) {
        tag.func_74777_a("Width", data.width);
        tag.func_74777_a("Height", data.height);
        tag.func_74783_a("Pixels", data.pixels);
        tag.func_74768_a("Seed", data.seed);
    }

    public static PaintingData readFrom(CompoundNBT tag) {
        return new PaintingData(tag.func_74765_d("Width"), tag.func_74765_d("Height"), tag.func_74759_k("Pixels"), false, tag.func_74762_e("Seed"));
    }

    private boolean isLegal(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int[] getComposite() {
        return this.composite;
    }

    public void setPixels(int[] pixels) {
        if (pixels.length == this.pixels.length) {
            this.pixels = pixels;
        }
        if (this.isClient) {
            this.recalculateComposite();
        }
    }

    private void recalculateComposite() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.composite[y * this.width + x] = NekoColors.getRGBColorBetween((double)(this.pixels[y * this.width + x] >> 24 & 0xFF) / 255.0, this.canvas[y * this.width + x], this.pixels[y * this.width + x]);
            }
        }
        this.updatePaintingHash();
    }

    public void setPixel(int x, int y, int color) {
        if (this.isLegal(x, y)) {
            this.pixels[y * this.width + x] = color;
            if (this.isClient) {
                this.recalculateCompositeAt(x, y);
            }
        }
    }

    private void recalculateCompositeAt(int x, int y) {
        this.composite[y * this.width + x] = NekoColors.getRGBColorBetween((double)(this.pixels[y * this.width + x] >> 24 & 0xFF) / 255.0, this.canvas[y * this.width + x], this.pixels[y * this.width + x]);
        this.updatePaintingHash();
    }

    public int getCompositeAt(int x, int y) {
        return this.composite[x + y * this.width];
    }

    public int getPixelAt(int x, int y) {
        return this.pixels[x + y * this.width];
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }
}

