/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.entities;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.client.ClientHelper;
import com.devbobcorn.nekoration.entities.ModEntityType;
import com.devbobcorn.nekoration.entities.PaintingData;
import com.devbobcorn.nekoration.exp.ExpNBTTypes;
import com.devbobcorn.nekoration.items.ModItems;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class PaintingEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    public PaintingData data;

    protected PaintingEntity(EntityType<PaintingEntity> type, World world) {
        super(ModEntityType.PAINTING_TYPE, world);
    }

    public PaintingEntity(World world, BlockPos pos, Direction dir, short w, short h) {
        super((EntityType)ModEntityType.$PAINTING_TYPE.get(), world, pos);
        this.func_174859_a(dir);
        this.data = new PaintingData(w, h, false, 20021222);
    }

    public PaintingEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super(ModEntityType.PAINTING_TYPE, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74774_a("Facing", (byte)this.field_174860_b.func_176736_b());
        PaintingData.writeTo(this.data, tag);
        super.func_213281_b(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.field_174860_b = Direction.func_176731_b((int)tag.func_74771_c("Facing"));
        this.data = PaintingData.readFrom(tag);
        super.func_70037_a(tag);
        this.func_174859_a(this.field_174860_b);
    }

    public int func_82329_d() {
        return this.data == null ? 1 : (int)this.data.getWidth();
    }

    public int func_82330_g() {
        return this.data == null ? 1 : (int)this.data.getHeight();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            if (stack.func_77973_b() == ModItems.PALETTE.get()) {
                CompoundNBT nbt = stack.func_77978_p();
                if (nbt != null && nbt.func_150297_b("active", (int)ExpNBTTypes.BYTE_NBT_ID)) {
                    byte a = nbt.func_74771_c("active");
                    int[] c = nbt.func_74759_k("colors");
                    Color[] col = new Color[6];
                    for (int i = 0; i < 6; ++i) {
                        col[i] = new Color(NekoColors.getRed(c[i]), NekoColors.getGreen(c[i]), NekoColors.getBlue(c[i]));
                    }
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.showPaintingScreen(this.func_145782_y(), a, col));
                } else {
                    ClientHelper.showPaintingScreen(this.func_145782_y());
                }
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.nekoration.message.paint_with_palette"), true);
            return ActionResultType.PASS;
        }
        return stack.func_77973_b() == ModItems.PALETTE.get() ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ModItems.PAINTING.get());
    }

    public void func_110128_b(Entity entity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (entity instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entity;
                if (playerentity.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_199703_a((IItemProvider)ModItems.PAINTING.get());
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public IPacket<?> func_213297_N() {
        IPacket packet = NetworkHooks.getEntitySpawningPacket((Entity)this);
        return packet;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeShort((int)this.data.getWidth());
        buffer.writeShort((int)this.data.getHeight());
        buffer.func_186875_a(this.data.getPixels());
        buffer.writeDouble(this.func_213303_ch().field_72450_a);
        buffer.writeDouble(this.func_213303_ch().field_72448_b);
        buffer.writeDouble(this.func_213303_ch().field_72449_c);
        buffer.func_179255_a(this.func_233580_cy_());
        buffer.writeByte(this.field_174860_b.func_176736_b());
        buffer.writeDouble(this.func_174813_aQ().field_72340_a);
        buffer.writeDouble(this.func_174813_aQ().field_72338_b);
        buffer.writeDouble(this.func_174813_aQ().field_72339_c);
        buffer.writeDouble(this.func_174813_aQ().field_72336_d);
        buffer.writeDouble(this.func_174813_aQ().field_72337_e);
        buffer.writeDouble(this.func_174813_aQ().field_72334_f);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.data = new PaintingData(additionalData.readShort(), additionalData.readShort(), additionalData.func_186863_b(), true, this.func_110124_au().hashCode());
        this.func_226288_n_(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.field_174861_a = additionalData.func_179259_c();
        byte dir = additionalData.readByte();
        this.field_174860_b = Direction.func_176731_b((int)dir);
        this.field_70126_B = this.field_70177_z = (float)(this.field_174860_b.func_176736_b() * 90);
        this.func_174826_a(new AxisAlignedBB(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble()));
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.data.clearCache(this.data.getPaintingHash());
        }
    }
}

