/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.dynamic_block;

import com.devbobcorn.nekoration.exp.dynamic_block.BlockCamouflage;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CamouflageBakedModel
implements IBakedModel {
    public static ModelProperty<Optional<BlockState>> COPIED_BLOCK = new ModelProperty();
    private IBakedModel modelWhenNotCamouflaged;
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loggedError = false;

    public CamouflageBakedModel(IBakedModel unCamouflagedModel) {
        this.modelWhenNotCamouflaged = unCamouflagedModel;
    }

    public static ModelDataMap getEmptyIModelData() {
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        builder.withInitial(COPIED_BLOCK, Optional.empty());
        ModelDataMap modelDataMap = builder.build();
        return modelDataMap;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getActualBakedModelFromIModelData(extraData).func_200117_a(state, side, rand);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        Optional<BlockState> bestAdjacentBlock = BlockCamouflage.selectBestAdjacentBlock(world, pos);
        ModelDataMap modelDataMap = CamouflageBakedModel.getEmptyIModelData();
        modelDataMap.setData(COPIED_BLOCK, bestAdjacentBlock);
        return modelDataMap;
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.getActualBakedModelFromIModelData(data).func_177554_e();
    }

    private IBakedModel getActualBakedModelFromIModelData(@Nonnull IModelData data) {
        IBakedModel retval = this.modelWhenNotCamouflaged;
        if (!data.hasProperty(COPIED_BLOCK)) {
            if (!loggedError) {
                LOGGER.error("IModelData did not have expected property COPIED_BLOCK");
                loggedError = true;
            }
            return retval;
        }
        Optional copiedBlock = (Optional)data.getData(COPIED_BLOCK);
        if (!copiedBlock.isPresent()) {
            return retval;
        }
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
        retval = blockRendererDispatcher.func_184389_a((BlockState)copiedBlock.get());
        return retval;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        throw new AssertionError((Object)"IBakedModel::getQuads should never be called, only IForgeBakedModel::getQuads");
    }

    public boolean func_177556_c() {
        return this.modelWhenNotCamouflaged.func_177556_c();
    }

    public ItemOverrideList func_188617_f() {
        return this.modelWhenNotCamouflaged.func_188617_f();
    }

    public boolean func_177555_b() {
        return this.modelWhenNotCamouflaged.func_177555_b();
    }

    public boolean func_230044_c_() {
        return this.modelWhenNotCamouflaged.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.modelWhenNotCamouflaged.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.modelWhenNotCamouflaged.func_177554_e();
    }
}

