/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.foot_locker;

import com.devbobcorn.nekoration.exp.foot_locker.TileEntityInventoryBasic;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockInventoryBasic
extends ContainerBlock {
    private static final Vector3d CHEST_MIN_CORNER = new Vector3d(1.0, 0.0, 1.0);
    private static final Vector3d CHEST_MAX_CORNER = new Vector3d(15.0, 8.0, 15.0);
    private static final VoxelShape CHEST_SHAPE = Block.func_208617_a((double)CHEST_MIN_CORNER.func_82615_a(), (double)CHEST_MIN_CORNER.func_82617_b(), (double)CHEST_MIN_CORNER.func_82616_c(), (double)CHEST_MAX_CORNER.func_82615_a(), (double)CHEST_MAX_CORNER.func_82617_b(), (double)CHEST_MAX_CORNER.func_82616_c());

    public BlockInventoryBasic() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.func_196283_a_(world);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityInventoryBasic();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider namedContainerProvider = this.func_220052_b(state, worldIn, pos);
        if (namedContainerProvider != null) {
            if (!(player instanceof ServerPlayerEntity)) {
                return ActionResultType.FAIL;
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, packetBuffer -> {});
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(blockPos);
            if (tileentity instanceof TileEntityInventoryBasic) {
                TileEntityInventoryBasic tileEntityInventoryBasic = (TileEntityInventoryBasic)tileentity;
                tileEntityInventoryBasic.dropAllContents(world, blockPos);
            }
            super.func_196243_a(state, world, blockPos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return false;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CHEST_SHAPE;
    }
}

