/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.foot_locker;

import com.devbobcorn.nekoration.exp.foot_locker.ChestContents;
import com.devbobcorn.nekoration.exp.foot_locker.StartupCommon;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerBasic
extends Container {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 9;
    public static final int TILE_INVENTORY_YPOS = 20;
    public static final int PLAYER_INVENTORY_YPOS = 51;
    private ChestContents chestContents;
    private static final Logger LOGGER = LogManager.getLogger();

    public static ContainerBasic createContainerServerSide(int windowID, PlayerInventory playerInventory, ChestContents chestContents) {
        return new ContainerBasic(windowID, playerInventory, chestContents);
    }

    public static ContainerBasic createContainerClientSide(int windowID, PlayerInventory playerInventory, PacketBuffer extraData) {
        ChestContents chestContents = ChestContents.createForClientSideContainer(9);
        return new ContainerBasic(windowID, playerInventory, chestContents);
    }

    private ContainerBasic(int windowID, PlayerInventory playerInventory, ChestContents chestContents) {
        super(StartupCommon.containerTypeContainerBasic, windowID);
        int slotNumber;
        int x;
        if (StartupCommon.containerTypeContainerBasic == null) {
            throw new IllegalStateException("Must initialise containerBasicContainerType before constructing a ContainerBasic!");
        }
        PlayerInvWrapper playerInventoryForge = new PlayerInvWrapper(playerInventory);
        this.chestContents = chestContents;
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 109;
        for (int x2 = 0; x2 < 9; ++x2) {
            int slotNumber2 = x2;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryForge, slotNumber2, 8 + 18 * x2, 109));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 51 + y * 18;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryForge, slotNumber, xpos, ypos));
            }
        }
        if (9 != chestContents.func_70302_i_()) {
            LOGGER.warn("Mismatched slot count in ContainerBasic(9) and TileInventory (" + chestContents.func_70302_i_() + ")");
        }
        int TILE_INVENTORY_XPOS = 8;
        for (x = 0; x < 9; ++x) {
            slotNumber = x;
            this.func_75146_a(new Slot((IInventory)chestContents, slotNumber, 8 + 18 * x, 20));
        }
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return this.chestContents.func_70300_a(playerEntity);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (!this.func_75135_a(sourceStack, 36, 45, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 45) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            LOGGER.warn("Invalid slotIndex:" + sourceSlotIndex);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(playerEntity, sourceStack);
        return copyOfSourceStack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }
}

