/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.monster_drink;

import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MonsterDrinkItem
extends Item {
    private static final int MAXIMUM_NUMBER_OF_BOTTLES = 1;
    public static final String NBT_TAG_NAME_FLAVOR = "color";
    public static final String NBT_TAG_NAME_FULLNESS = "fullness";

    public MonsterDrinkItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    public static EnumBottleFlavor getFlavor(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        return EnumBottleFlavor.fromNBT(compoundNBT, NBT_TAG_NAME_FLAVOR);
    }

    public static EnumBottleFullness getFullness(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        return EnumBottleFullness.fromNBT(compoundNBT, NBT_TAG_NAME_FULLNESS);
    }

    public static float getFullnessPropertyOverride(ItemStack itemStack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        EnumBottleFullness enumBottleFullness = MonsterDrinkItem.getFullness(itemStack);
        return enumBottleFullness.getPropertyOverrideValue();
    }

    public static void setFlavor(ItemStack stack, EnumBottleFlavor enumBottleFlavor) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        enumBottleFlavor.putIntoNBT(compoundNBT, NBT_TAG_NAME_FLAVOR);
    }

    public static void setFullness(ItemStack stack, EnumBottleFullness enumBottleFullness) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        enumBottleFullness.putIntoNBT(compoundNBT, NBT_TAG_NAME_FULLNESS);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (EnumBottleFlavor flavor : EnumBottleFlavor.values()) {
                ItemStack subItemStack = new ItemStack((IItemProvider)this, 1);
                MonsterDrinkItem.setFlavor(subItemStack, flavor);
                MonsterDrinkItem.setFullness(subItemStack, EnumBottleFullness.FULL);
                subItems.add((Object)subItemStack);
            }
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        int TICKS_PER_SECOND = 20;
        int DRINK_DURATION_SECONDS = 2;
        return 40;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemStackHeld = playerIn.func_184586_b(hand);
        EnumBottleFullness fullness = MonsterDrinkItem.getFullness(itemStackHeld);
        if (fullness == EnumBottleFullness.EMPTY) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStackHeld);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)itemStackHeld);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        EnumBottleFullness fullness = MonsterDrinkItem.getFullness(stack);
        fullness = fullness.decreaseFullnessByOneStep();
        fullness.putIntoNBT(stack.func_77978_p(), NBT_TAG_NAME_FULLNESS);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        EnumBottleFlavor flavor = MonsterDrinkItem.getFlavor(stack);
        return super.func_77667_c(stack) + "." + flavor.func_176610_l();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String fullnessText = MonsterDrinkItem.getFullness(stack).getDescription();
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[]{fullnessText});
    }

    public static enum EnumBottleFlavor implements IStringSerializable
    {
        LEMON(0, "lemon", Color.YELLOW),
        LIME(1, "lime", Color.GREEN),
        CHERRY(2, "cherry", Color.RED),
        ORANGE(3, "orange", Color.ORANGE);

        private final byte nbtID;
        private final String name;
        private final Color renderColor;

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Color getRenderColor() {
            return this.renderColor;
        }

        public static EnumBottleFlavor fromNBT(CompoundNBT compoundNBT, String tagname) {
            byte flavorID = 0;
            if (compoundNBT != null && compoundNBT.func_74764_b(tagname)) {
                flavorID = compoundNBT.func_74771_c(tagname);
            }
            Optional<EnumBottleFlavor> flavor = EnumBottleFlavor.getFlavorFromID(flavorID);
            return flavor.orElse(LEMON);
        }

        public void putIntoNBT(CompoundNBT compoundNBT, String tagname) {
            compoundNBT.func_74774_a(tagname, this.nbtID);
        }

        private EnumBottleFlavor(int i_NBT_ID, String i_name, Color i_renderColor) {
            this.nbtID = (byte)i_NBT_ID;
            this.name = i_name;
            this.renderColor = i_renderColor;
        }

        private static Optional<EnumBottleFlavor> getFlavorFromID(byte ID) {
            for (EnumBottleFlavor flavor : EnumBottleFlavor.values()) {
                if (flavor.nbtID != ID) continue;
                return Optional.of(flavor);
            }
            return Optional.empty();
        }
    }

    public static enum EnumBottleFullness implements IStringSerializable
    {
        EMPTY(0, "0pc", "empty"),
        ONE_QUARTER(1, "25pc", "nearly empty"),
        ONE_HALF(2, "50pc", "half full"),
        THREE_QUARTERS(3, "75pc", "mostly full"),
        FULL(4, "100pc", "full");

        private final byte nbtID;
        private final String name;
        private final String description;

        public String toString() {
            return this.description;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public float getPropertyOverrideValue() {
            return this.nbtID;
        }

        public EnumBottleFullness decreaseFullnessByOneStep() {
            if (this.nbtID == 0) {
                return this;
            }
            for (EnumBottleFullness fullness : EnumBottleFullness.values()) {
                if (fullness.nbtID != this.nbtID - 1) continue;
                return fullness;
            }
            return this;
        }

        public static EnumBottleFullness fromNBT(CompoundNBT compoundNBT, String tagname) {
            byte fullnessID = 0;
            if (compoundNBT != null && compoundNBT.func_74764_b(tagname)) {
                fullnessID = compoundNBT.func_74771_c(tagname);
            }
            Optional<EnumBottleFullness> fullness = EnumBottleFullness.getFullnessFromID(fullnessID);
            return fullness.orElse(FULL);
        }

        public void putIntoNBT(CompoundNBT compoundNBT, String tagname) {
            compoundNBT.func_74774_a(tagname, this.nbtID);
        }

        private EnumBottleFullness(int i_NBT_ID, String i_name, String i_description) {
            this.nbtID = (byte)i_NBT_ID;
            this.name = i_name;
            this.description = i_description;
        }

        private static Optional<EnumBottleFullness> getFullnessFromID(byte ID) {
            for (EnumBottleFullness fullness : EnumBottleFullness.values()) {
                if (fullness.nbtID != ID) continue;
                return Optional.of(fullness);
            }
            return Optional.empty();
        }
    }
}

