/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.tile_entity;

import com.devbobcorn.nekoration.exp.tile_entity.AnimationTickCounter;
import com.devbobcorn.nekoration.exp.tile_entity.ModelHourglass;
import com.devbobcorn.nekoration.exp.tile_entity.TileEntityMBE21;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderModelHourglass {
    static final ModelHourglass model = new ModelHourglass();
    public static final ResourceLocation HOURGLASS_MODEL_TEXTURE = new ResourceLocation("exp", "textures/misc/hourglass.png");

    public static void renderUsingModel(TileEntityMBE21 tileEntityMBE21, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffers, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        Vector3d TRANSLATION_OFFSET = new Vector3d(0.5, 1.5, 0.5);
        matrixStack.func_227861_a_(TRANSLATION_OFFSET.field_72450_a, TRANSLATION_OFFSET.field_72448_b, TRANSLATION_OFFSET.field_72449_c);
        double animationTicks = (float)AnimationTickCounter.getTotalElapsedTicksInGame() + partialTicks;
        AnimationState animationState = new AnimationState(animationTicks += (double)new Random(tileEntityMBE21.func_174877_v().hashCode()).nextInt(Integer.MAX_VALUE));
        Vector3f wiggle = RenderModelHourglass.getWiggle(animationTicks);
        matrixStack.func_227861_a_((double)wiggle.func_195899_a(), (double)wiggle.func_195900_b(), (double)wiggle.func_195902_c());
        boolean USE_ENTITY_MODEL_TRANSFORMATIONS = true;
        if (USE_ENTITY_MODEL_TRANSFORMATIONS) {
            matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            matrixStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        }
        Color sandColour = tileEntityMBE21.getArtifactColour();
        try {
            float sandColourRed = (float)sandColour.getRed() / 255.0f;
            float sandColourGreen = (float)sandColour.getGreen() / 255.0f;
            float sandColourBlue = (float)sandColour.getBlue() / 255.0f;
            IVertexBuilder renderBuffer = renderBuffers.getBuffer(model.func_228282_a_(HOURGLASS_MODEL_TEXTURE));
            model.render(matrixStack, renderBuffer, combinedLight, combinedOverlay, sandColourRed, sandColourGreen, sandColourBlue, animationState.flipRotationDegrees, animationState.fractionSandInTop, animationState.fractionSandInBottom);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStack.func_227865_b_();
    }

    private static Vector3f getWiggle(double animationTicks) {
        int TICKS_PER_SECOND = 20;
        double X_WIGGLE_CYCLE_SECONDS = 0.7;
        double Y_WIGGLE_CYCLE_SECONDS = 2.3;
        double Z_WIGGLE_CYCLE_SECONDS = 0.76;
        double X_WIGGLE_CYCLE_TICKS = 14.0;
        double Y_WIGGLE_CYCLE_TICKS = 46.0;
        double Z_WIGGLE_CYCLE_TICKS = 15.2;
        float XZ_WIGGLE_AMPLITUDE = 0.01f;
        float Y_WIGGLE_AMPLITUDE = 0.05f;
        double RADIANS_PER_CYCLE = Math.PI * 2;
        double wiggle_x = (double)0.01f * Math.cos(animationTicks / 14.0 * (Math.PI * 2));
        double wiggle_y = (double)0.05f * Math.sin(animationTicks / 46.0 * (Math.PI * 2));
        double wiggle_z = (double)0.01f * Math.sin(animationTicks / 15.2 * (Math.PI * 2));
        return new Vector3f((float)wiggle_x, (float)wiggle_y, (float)wiggle_z);
    }

    static class AnimationState {
        public float flipRotationDegrees;
        public float fractionSandInTop;
        public float fractionSandInBottom;
        private final float FLIP_DURATION_SECONDS = 0.2f;
        private final float SAND_DEPLETION_SECONDS = 17.8f;
        private final float HALF_CYCLE_DURATION_SECONDS = 18.0f;
        private final float FULL_CYCLE_DURATION_SECONDS = 36.0f;
        private final int TICKS_PER_SECOND = 20;
        private final float FLIP_DURATION_TICKS = 4.0f;
        private final float SAND_DEPLETION_TICKS = 356.0f;
        private final float FULL_CYCLE_DURATION_TICKS = 720.0f;

        public AnimationState(double animationTicks) {
            float cycleOffset = (float)(animationTicks % 720.0);
            if (cycleOffset <= 356.0f) {
                this.flipRotationDegrees = 0.0f;
                this.fractionSandInTop = 1.0f - cycleOffset / 356.0f;
            } else if ((cycleOffset -= 356.0f) <= 4.0f) {
                this.flipRotationDegrees = 180.0f * cycleOffset / 4.0f;
                this.fractionSandInTop = 0.0f;
            } else if ((cycleOffset -= 4.0f) <= 356.0f) {
                this.flipRotationDegrees = 180.0f;
                this.fractionSandInTop = cycleOffset / 356.0f;
            } else {
                this.flipRotationDegrees = 180.0f + 180.0f * (cycleOffset -= 356.0f) / 4.0f;
                this.fractionSandInTop = 1.0f;
            }
            this.fractionSandInBottom = 1.0f - this.fractionSandInTop;
        }
    }
}

