/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.tile_entity;

import com.devbobcorn.nekoration.exp.UsefulFunctions;
import com.devbobcorn.nekoration.exp.tile_entity.BlockMBE21;
import com.devbobcorn.nekoration.exp.tile_entity.StartupCommon;
import com.devbobcorn.nekoration.exp.tile_entity.TileEntityMBE21;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RenderWavefrontObj {
    public static void renderWavefrontObj(TileEntityMBE21 tileEntityMBE21, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffers, int combinedLight, int combinedOverlay) {
        double scaleY;
        Vector3d OBJ_MODEL_SIZE = new Vector3d(1.0, 2.0, 1.0);
        Vector3d OBJ_MODEL_BOTTOM_APEX = new Vector3d(0.0, -1.0, 0.0);
        Vector3d HOPPER_MIDDLE_OF_TOP = new Vector3d(0.5, 0.6875, 0.5);
        Vector3d WORLD_MODEL_SIZE = new Vector3d(0.25, 0.5, 0.25);
        boolean SCALE_EVENLY_BASED_ON_Y = true;
        double scaleX = scaleY = WORLD_MODEL_SIZE.func_82617_b() / OBJ_MODEL_SIZE.func_82617_b();
        double scaleZ = scaleY;
        Vector3d OBJ_MODEL_BOTTOM_APEX_WORLD_SPACE = new Vector3d(OBJ_MODEL_BOTTOM_APEX.func_82615_a() * scaleX, OBJ_MODEL_BOTTOM_APEX.func_82617_b() * scaleY, OBJ_MODEL_BOTTOM_APEX.func_82616_c() * scaleZ);
        Vector3d TRANSLATION_OFFSET = HOPPER_MIDDLE_OF_TOP.func_178788_d(OBJ_MODEL_BOTTOM_APEX_WORLD_SPACE);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(TRANSLATION_OFFSET.field_72450_a, TRANSLATION_OFFSET.field_72448_b, TRANSLATION_OFFSET.field_72449_c);
        RenderWavefrontObj.applyAnimations(tileEntityMBE21, matrixStack);
        matrixStack.func_227862_a_((float)scaleX, (float)scaleY, (float)scaleZ);
        Color artifactColour = tileEntityMBE21.getArtifactColour();
        try {
            BlockState state = (BlockState)StartupCommon.blockMBE21.func_176223_P().func_206870_a(BlockMBE21.USE_WAVEFRONT_OBJ_MODEL, (Comparable)Boolean.valueOf(true));
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel model = dispatcher.func_184389_a(state);
            MatrixStack.Entry currentMatrix = matrixStack.func_227866_c_();
            float red = (float)artifactColour.getRed() / 255.0f;
            float green = (float)artifactColour.getGreen() / 255.0f;
            float blue = (float)artifactColour.getBlue() / 255.0f;
            combinedLight = RenderWavefrontObj.getCombinedLight(tileEntityMBE21, combinedLight);
            IVertexBuilder vertexBuffer = renderBuffers.getBuffer(RenderType.func_228639_c_());
            dispatcher.func_175019_b().renderModel(currentMatrix, vertexBuffer, null, model, red, green, blue, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStack.func_227865_b_();
    }

    private static void applyAnimations(TileEntityMBE21 tileEntityMBE21, MatrixStack matrixStack) {
        double playerDistance = 0.0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos blockPos = tileEntityMBE21.func_174877_v();
        if (player != null && blockPos != null) {
            Vector3d pedestalCentre = Vector3d.func_237491_b_((Vector3i)blockPos).func_72441_c(0.5, 1.0, 0.5);
            Vector3d playerFeet = player.func_213303_ch();
            playerDistance = playerFeet.func_72438_d(pedestalCentre);
        }
        double DISTANCE_FOR_MIN_SPIN = 4.0;
        double DISTANCE_FOR_MAX_SPIN = 2.0;
        double DISTANCE_FOR_MIN_LEVITATE = 6.0;
        double DISTANCE_FOR_MAX_LEVITATE = 4.0;
        double MIN_LEVITATE_HEIGHT = 0.0;
        double MAX_LEVITATE_HEIGHT = 0.5;
        double levitateHeight = UsefulFunctions.interpolate_with_clipping(playerDistance, 6.0, 4.0, 0.0, 0.5);
        matrixStack.func_227861_a_(0.0, levitateHeight, 0.0);
        double MIN_REV_PER_SEC = 0.0;
        double MAX_REV_PER_SEC = 0.5;
        double revsPerSecond = UsefulFunctions.interpolate_with_clipping(playerDistance, 4.0, 2.0, 0.0, 0.5);
        double angularPositionInDegrees = tileEntityMBE21.getNextAngularPosition(revsPerSecond);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angularPositionInDegrees));
    }

    private static int getCombinedLight(TileEntityMBE21 tileEntityMBE21, int ambientCombinedLight) {
        double playerDistance = 0.0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos blockPos = tileEntityMBE21.func_174877_v();
        if (player != null && blockPos != null) {
            Vector3d pedestalCentre = Vector3d.func_237491_b_((Vector3i)blockPos).func_72441_c(0.5, 1.0, 0.5);
            Vector3d playerFeet = player.func_213303_ch();
            playerDistance = playerFeet.func_72438_d(pedestalCentre);
        }
        double DISTANCE_FOR_MIN_GLOW = 8.0;
        double DISTANCE_FOR_MAX_GLOW = 6.0;
        double MIN_GLOW = 0.0;
        double MAX_GLOW = 1.0;
        double glowMultiplier = UsefulFunctions.interpolate_with_clipping(playerDistance, 8.0, 6.0, 0.0, 1.0);
        int SKY_LIGHT_VALUE = (int)(15.0 * glowMultiplier);
        int BLOCK_LIGHT_VALUE = (int)(15.0 * glowMultiplier);
        int repackedValue = LightTexture.func_228451_a_((int)BLOCK_LIGHT_VALUE, (int)SKY_LIGHT_VALUE);
        return repackedValue;
    }
}

