/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.exp.tile_entity;

import com.devbobcorn.nekoration.exp.ExpNBTTypes;
import com.devbobcorn.nekoration.exp.tile_entity.StartupCommon;
import java.awt.Color;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityMBE21
extends TileEntity {
    public static final Color INVALID_COLOR = null;
    private Color artifactColour = INVALID_COLOR;
    private EnumRenderStyle artifactRenderStyle = EnumRenderStyle.QUADS;
    private final long INVALID_TIME = 0L;
    private long lastTime = 0L;
    private double lastAngularPosition;

    public TileEntityMBE21() {
        super(StartupCommon.tileEntityDataTypeMBE21);
    }

    public Color getArtifactColour() {
        return this.artifactColour;
    }

    public void setArtifactColour(Color newColour) {
        this.artifactColour = newColour;
    }

    public EnumRenderStyle getArtifactRenderStyle() {
        return this.artifactRenderStyle;
    }

    public void setArtifactRenderStyle(EnumRenderStyle artifactRenderStyle) {
        this.artifactRenderStyle = artifactRenderStyle;
    }

    public double getNextAngularPosition(double revsPerSecond) {
        long timeNow = System.nanoTime();
        if (this.lastTime == 0L) {
            this.lastTime = timeNow;
            this.lastAngularPosition = 0.0;
        }
        double DEGREES_PER_REV = 360.0;
        double NANOSECONDS_PER_SECOND = 1.0E9;
        double nextAngularPosition = this.lastAngularPosition + (double)(timeNow - this.lastTime) * revsPerSecond * 360.0 / 1.0E9;
        this.lastAngularPosition = nextAngularPosition %= 360.0;
        this.lastTime = timeNow;
        return nextAngularPosition;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        int tileEntityType = 42;
        return new SUpdateTileEntityPacket(this.field_174879_c, tileEntityType, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT tag) {
        this.func_230337_a_(blockState, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        if (this.artifactColour != INVALID_COLOR) {
            parentNBTTagCompound.func_74768_a("artifactColour", this.artifactColour.getRGB());
        }
        this.artifactRenderStyle.putIntoNBT(parentNBTTagCompound, "artifactRenderStyle");
        return parentNBTTagCompound;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        super.func_230337_a_(blockState, parentNBTTagCompound);
        byte NBT_INT_ID = ExpNBTTypes.INT_NBT_ID;
        Color readArtifactColour = INVALID_COLOR;
        if (parentNBTTagCompound.func_150297_b("artifactColour", (int)NBT_INT_ID)) {
            int colorRGB = parentNBTTagCompound.func_74762_e("artifactColour");
            readArtifactColour = new Color(colorRGB);
        }
        this.artifactColour = readArtifactColour;
        this.artifactRenderStyle = EnumRenderStyle.fromNBT(parentNBTTagCompound, "artifactRenderStyle");
    }

    public double func_145833_n() {
        int MAXIMUM_DISTANCE_IN_BLOCKS = 32;
        return 1024.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
        return aabb;
    }

    public static enum EnumRenderStyle {
        QUADS(1),
        BLOCKQUADS(2),
        WAVEFRONT(3);

        private byte nbtID;

        public EnumRenderStyle getNextStyle() {
            int nextLargestID = this.nbtID + 1;
            for (EnumRenderStyle enumRenderStyle : EnumRenderStyle.values()) {
                if (enumRenderStyle.nbtID != nextLargestID) continue;
                return enumRenderStyle;
            }
            return QUADS;
        }

        public static EnumRenderStyle fromNBT(CompoundNBT compoundNBT, String tagname) {
            byte renderStyleID = 0;
            if (compoundNBT != null && compoundNBT.func_74764_b(tagname)) {
                renderStyleID = compoundNBT.func_74771_c(tagname);
            }
            Optional<EnumRenderStyle> enumRenderStyle = EnumRenderStyle.getEnumRenderStyleFromID(renderStyleID);
            return enumRenderStyle.orElse(QUADS);
        }

        public void putIntoNBT(CompoundNBT compoundNBT, String tagname) {
            compoundNBT.func_74774_a(tagname, this.nbtID);
        }

        public static EnumRenderStyle pickRandom() {
            int count = EnumRenderStyle.values().length;
            int whichIdx = new Random().nextInt(count);
            return EnumRenderStyle.values()[whichIdx];
        }

        private static Optional<EnumRenderStyle> getEnumRenderStyleFromID(byte ID) {
            for (EnumRenderStyle enumRenderStyle : EnumRenderStyle.values()) {
                if (enumRenderStyle.nbtID != ID) continue;
                return Optional.of(enumRenderStyle);
            }
            return Optional.empty();
        }

        private EnumRenderStyle(int i_NBT_ID) {
            this.nbtID = (byte)i_NBT_ID;
        }
    }
}

