/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.items;

import com.devbobcorn.nekoration.NekoColors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class DyeableBlockItem
extends BlockItem {
    public static final String COLOR = "color";
    private final boolean showAllVariants;

    public DyeableBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
        this.showAllVariants = true;
    }

    public DyeableBlockItem(Block block, Item.Properties settings, boolean allVariants) {
        super(block, settings);
        this.showAllVariants = allVariants;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            if (this.showAllVariants) {
                for (NekoColors.EnumNekoColor color : NekoColors.EnumNekoColor.values()) {
                    ItemStack subItemStack = new ItemStack((IItemProvider)this, 1);
                    DyeableBlockItem.setColor(subItemStack, color);
                    subItems.add((Object)subItemStack);
                }
            } else {
                ItemStack subItemStack = new ItemStack((IItemProvider)this, 1);
                DyeableBlockItem.setColor(subItemStack, NekoColors.EnumNekoColor.WHITE);
                subItems.add((Object)subItemStack);
            }
        }
    }

    public static NekoColors.EnumNekoColor getColor(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        return NekoColors.EnumNekoColor.fromNBT(compoundNBT, COLOR);
    }

    public static void setColor(ItemStack stack, NekoColors.EnumNekoColor color) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        color.putIntoNBT(compoundNBT, COLOR);
    }

    public static float getColorPropertyOverride(ItemStack itemStack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        NekoColors.EnumNekoColor color = DyeableBlockItem.getColor(itemStack);
        return color.getPropertyOverrideValue();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String colorText = new TranslationTextComponent("color.nekoration." + DyeableBlockItem.getColor(stack).func_176610_l()).getString();
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[]{colorText});
    }
}

