/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.items;

import com.devbobcorn.nekoration.client.ClientHelper;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class PaintingItem
extends Item {
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";

    public PaintingItem(Item.Properties settings) {
        super(settings);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos blockpos = ctx.func_195995_a();
        Direction direction = ctx.func_196000_l();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        PlayerEntity playerentity = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        if (playerentity != null && !this.mayPlace(playerentity, direction, stack, blockpos1)) {
            return ActionResultType.FAIL;
        }
        World world = ctx.func_195991_k();
        PaintingEntity hangingentity = new PaintingEntity(world, blockpos1, direction, (short)(PaintingItem.getWidth(stack) * 16), (short)(PaintingItem.getHeight(stack) * 16));
        hangingentity.func_70107_b(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            EntityType.func_208048_a((World)world, (PlayerEntity)playerentity, (Entity)hangingentity, (CompoundNBT)compoundnbt);
        }
        if (hangingentity.func_70518_d()) {
            if (!world.field_72995_K) {
                hangingentity.func_184523_o();
                world.func_217376_c((Entity)hangingentity);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.showPaintingSizeScreen(hand));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    protected boolean mayPlace(PlayerEntity player, Direction dir, ItemStack stack, BlockPos pos) {
        return !dir.func_176740_k().func_200128_b() && player.func_175151_a(pos, dir, stack);
    }

    public static int getWidth(ItemStack stack) {
        short w = stack.func_196082_o().func_74765_d(WIDTH);
        return w <= 0 ? (short)1 : w;
    }

    public static void setWidth(ItemStack stack, short w) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74777_a(WIDTH, w);
    }

    public static int getHeight(ItemStack stack) {
        short h = stack.func_196082_o().func_74765_d(HEIGHT);
        return h <= 0 ? (short)1 : h;
    }

    public static void setHeight(ItemStack stack, short h) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74777_a(HEIGHT, h);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[]{PaintingItem.getWidth(stack), PaintingItem.getHeight(stack)});
    }
}

