/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.network.S2CUpdatePaintingData;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class C2SUpdatePaintingData {
    public int paintingId;
    public int[] pixels;
    public int compositeHash;

    public C2SUpdatePaintingData(int id, int[] pixels, int hash) {
        this.paintingId = id;
        this.pixels = pixels;
        this.compositeHash = hash;
    }

    public static void encode(C2SUpdatePaintingData msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.paintingId);
        packetBuffer.func_186875_a(msg.pixels);
        packetBuffer.writeInt(msg.compositeHash);
    }

    public static C2SUpdatePaintingData decode(PacketBuffer packetBuffer) {
        int i = packetBuffer.readInt();
        int[] p = packetBuffer.func_186863_b();
        int hash = packetBuffer.readInt();
        return new C2SUpdatePaintingData(i, p, hash);
    }

    public static void handle(C2SUpdatePaintingData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Entity entity;
            ServerPlayerEntity player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null && (entity = player.field_70170_p.func_73045_a(msg.paintingId)) instanceof PaintingEntity) {
                ((PaintingEntity)entity).data.setPixels(msg.pixels);
                System.out.println("Painting Updated!");
                S2CUpdatePaintingData packet = new S2CUpdatePaintingData(msg.paintingId, msg.pixels, msg.compositeHash);
                ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

