/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.blocks.entities.EaselMenuBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2CUpdateEaselMenuData {
    public ItemStack[] items = new ItemStack[8];
    public BlockPos pos = BlockPos.field_177992_a;
    public ITextComponent[] texts = new ITextComponent[8];
    public DyeColor[] colors = new DyeColor[8];
    public boolean glow;

    public S2CUpdateEaselMenuData(BlockPos pos, ItemStack[] items, ITextComponent[] texts, DyeColor[] colors, boolean glowing) {
        this.pos = pos;
        this.items = items;
        this.texts = texts;
        this.colors = colors;
        this.glow = glowing;
    }

    public static void encode(S2CUpdateEaselMenuData msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179255_a(msg.pos);
        for (int i = 0; i < 8; ++i) {
            packetBuffer.writeItemStack(msg.items[i], false);
            packetBuffer.func_179256_a(msg.texts[i]);
            packetBuffer.func_179249_a((Enum)msg.colors[i]);
        }
        packetBuffer.writeBoolean(msg.glow);
    }

    public static S2CUpdateEaselMenuData decode(PacketBuffer packetBuffer) {
        BlockPos pos = packetBuffer.func_179259_c();
        ItemStack[] t = new ItemStack[8];
        ITextComponent[] x = new ITextComponent[8];
        DyeColor[] c = new DyeColor[8];
        for (int i = 0; i < 8; ++i) {
            t[i] = packetBuffer.func_150791_c();
            x[i] = packetBuffer.func_179258_d();
            c[i] = (DyeColor)packetBuffer.func_179257_a(DyeColor.class);
        }
        return new S2CUpdateEaselMenuData(pos, t, x, c, packetBuffer.readBoolean());
    }

    public static void handle(S2CUpdateEaselMenuData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world.func_195588_v(msg.pos) && (tileEntity = world.func_175625_s(msg.pos)) instanceof EaselMenuBlockEntity) {
                EaselMenuBlockEntity te = (EaselMenuBlockEntity)tileEntity;
                for (int i = 0; i < 8; ++i) {
                    te.renderItems[i] = msg.items[i];
                    te.setMessage(i, msg.texts[i]);
                }
                te.setColors(msg.colors);
                te.setGlowing(msg.glow);
                tileEntity.func_70296_d();
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

