/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.entities.PaintingEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2CUpdatePaintingData {
    public int paintingId;
    public int[] pixels;
    public int compositeHash;

    public S2CUpdatePaintingData(int id, int[] p, int hash) {
        this.paintingId = id;
        this.pixels = p;
        this.compositeHash = hash;
    }

    public static void encode(S2CUpdatePaintingData msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.paintingId);
        packetBuffer.func_186875_a(msg.pixels);
        packetBuffer.writeInt(msg.compositeHash);
    }

    public static S2CUpdatePaintingData decode(PacketBuffer packetBuffer) {
        int id = packetBuffer.readInt();
        int[] p = packetBuffer.func_186863_b();
        int hash = packetBuffer.readInt();
        return new S2CUpdatePaintingData(id, p, hash);
    }

    public static void handle(S2CUpdatePaintingData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = world.func_73045_a(msg.paintingId);
            if (entity instanceof PaintingEntity) {
                PaintingEntity pe = (PaintingEntity)entity;
                if (pe.data.getPaintingHash() != msg.compositeHash) {
                    pe.data.clearCache(pe.data.getPaintingHash());
                    pe.data.setPixels(msg.pixels);
                }
                pe.data.cache();
                System.out.println("Data Synced: " + String.valueOf(pe.data.getPaintingHash() == msg.compositeHash));
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

