/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.blocks.entities.CustomBlockEntity;
import com.devbobcorn.nekoration.items.ModItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;

public class CustomBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty MODEL = BlockStateProperties.f_61422_;

    public CustomBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> s) {
        s.m_61104_(new Property[]{MODEL});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof CustomBlockEntity) {
            CustomBlockEntity te = (CustomBlockEntity)tileEntity;
            switch (placer.m_6350_().m_122424_()) {
                default: {
                    break;
                }
                case EAST: {
                    te.dir = 6;
                    break;
                }
                case NORTH: {
                    te.dir = 12;
                    break;
                }
                case WEST: {
                    te.dir = 18;
                }
            }
            return;
        }
        f_49790_.error("Tile Entity NOT Found!");
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        CustomBlockEntity te = (CustomBlockEntity)world.m_7702_(pos);
        if (item == ModItems.PAW_15.get()) {
            te.dir = (byte)((te.dir + 1) % 24);
            return InteractionResult.CONSUME;
        }
        if (item == ModItems.PAW_90.get()) {
            te.dir = (byte)((te.dir + 6) % 24);
            return InteractionResult.CONSUME;
        }
        if (item == ModItems.PAW_LEFT.get()) {
            te.offset[0] = te.offset[0] - 1;
        } else if (item == ModItems.PAW_RIGHT.get()) {
            te.offset[0] = te.offset[0] + 1;
        } else if (item == ModItems.PAW_UP.get()) {
            te.offset[1] = te.offset[1] + 1;
        } else if (item == ModItems.PAW_DOWN.get()) {
            te.offset[1] = te.offset[1] - 1;
        } else if (item == ModItems.PAW_NEAR.get()) {
            te.offset[2] = te.offset[2] + 1;
        } else if (item == ModItems.PAW_FAR.get()) {
            te.offset[2] = te.offset[2] - 1;
        } else if (item == ModItems.PALETTE.get()) {
            CompoundTag nbt = itemStack.m_41783_();
            byte a = nbt.m_128445_("active");
            int[] c = nbt.m_128465_("colors");
            te.color[0] = NekoColors.getRed(c[a]);
            te.color[1] = NekoColors.getGreen(c[a]);
            te.color[2] = NekoColors.getBlue(c[a]);
            System.out.println("Dye Custom Block!");
        } else if (item instanceof BlockItem) {
            if (((BlockItem)item).m_40614_() instanceof CustomBlock) {
                return InteractionResult.PASS;
            }
            te.model = 16;
            BlockState newState = ((BlockItem)item).m_40614_().m_5573_(new BlockPlaceContext(player, hand, itemStack, hit));
            if (te.displayBlock == newState) {
                return InteractionResult.PASS;
            }
            te.displayBlock = newState;
            ItemStack newStack = itemStack.m_41777_();
            newStack.m_41764_(1);
            te.containItem = newStack;
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        return Collections.singletonList(stack);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CustomBlockEntity(pos, state);
    }
}

