/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks.entities;

import com.devbobcorn.nekoration.blocks.containers.EaselMenuMenu;
import com.devbobcorn.nekoration.blocks.entities.ContainerBlockEntity;
import com.devbobcorn.nekoration.blocks.entities.ModBlockEntityType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EaselMenuBlockEntity
extends ContainerBlockEntity {
    public static final int NUMBER_OF_SLOTS = 8;
    private final Component[] messages = new Component[]{TextComponent.f_131282_, TextComponent.f_131282_, TextComponent.f_131282_, TextComponent.f_131282_, TextComponent.f_131282_, TextComponent.f_131282_, TextComponent.f_131282_, TextComponent.f_131282_};
    private final ItemStack airStack = ItemStack.f_41583_;
    public ItemStack[] renderItems = new ItemStack[]{this.airStack, this.airStack, this.airStack, this.airStack, this.airStack, this.airStack, this.airStack, this.airStack};
    private boolean isEditable = true;
    private Player playerWhoMayEdit;
    private DyeColor[] textColors = new DyeColor[]{DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY, DyeColor.GRAY};
    private boolean isGlowing;
    public final boolean white;

    public EaselMenuBlockEntity(BlockPos pos, BlockState state) {
        this(false, pos, state);
    }

    public EaselMenuBlockEntity(boolean w, BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.EASEL_MENU_TYPE.get(), pos, state);
        this.white = w;
        this.isGlowing = false;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        int i;
        super.m_6945_(tag);
        for (i = 0; i < 8; ++i) {
            String s = Component.Serializer.m_130703_((Component)this.messages[i]);
            tag.m_128359_("Text" + (i + 1), s);
        }
        for (i = 0; i < 8; ++i) {
            tag.m_128359_("Color" + i, this.textColors[i].m_41065_());
        }
        tag.m_128379_("Glowing", this.isGlowing);
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        for (i = 0; i < 8; ++i) {
            this.renderItems[i] = this.m_8020_(i);
        }
        for (i = 0; i < 8; ++i) {
            String s = tag.m_128461_("Text" + (i + 1));
            MutableComponent itextcomponent = Component.Serializer.m_130701_((String)(s.isEmpty() ? "\"\"" : s));
            this.messages[i] = itextcomponent;
        }
        for (i = 0; i < 8; ++i) {
            this.textColors[i] = DyeColor.m_41057_((String)tag.m_128461_("Color" + i), (DyeColor)DyeColor.GRAY);
        }
        this.isGlowing = tag.m_128471_("Glowing");
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 2020, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public boolean m_6326_() {
        return true;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (!editable) {
            this.playerWhoMayEdit = null;
        }
    }

    public void setAllowedPlayerEditor(Player player) {
        this.playerWhoMayEdit = player;
    }

    public Player getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public int m_6643_() {
        return 8;
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.nekoration.easel_menu");
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.nekoration.easel_menu");
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new EaselMenuMenu(windowId, playerInventory, this);
    }

    public Component getMessage(int line) {
        return this.messages[line];
    }

    public void setMessage(int line, Component text) {
        this.messages[line] = text;
    }

    public Component[] getMessages() {
        return this.messages;
    }

    public boolean getGlowing() {
        return this.isGlowing;
    }

    public void setGlowing(boolean glow) {
        this.isGlowing = glow;
    }

    public boolean toggleGlowing() {
        this.isGlowing = !this.isGlowing;
        return this.isGlowing;
    }

    public DyeColor[] getColors() {
        return this.textColors;
    }

    public void setColors(DyeColor[] color) {
        this.textColors = color;
    }

    public DyeColor getColor(int line) {
        return this.textColors[line];
    }

    public void setColor(int line, DyeColor color) {
        this.textColors[line] = color;
    }
}

