/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.event;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.client.gui.widget.IconButton;
import com.devbobcorn.nekoration.client.gui.widget.WoodTypeButton;
import com.devbobcorn.nekoration.items.HalfTimberBlockItem;
import com.devbobcorn.nekoration.items.ModItemTabs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreativeInventoryEvents {
    private static final ResourceLocation ICONS = new ResourceLocation("nekoration", "textures/gui/icons.png");
    private static int startIndex;
    private List<WoodFilter> filters;
    private List<WoodTypeButton> buttons;
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private boolean viewingFurnitureTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;
    private static final Logger LOGGER;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.filters = null;
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof CreativeModeInventoryScreen) {
            if (this.filters == null) {
                this.compileItems();
            }
            this.viewingFurnitureTab = false;
            this.guiCenterX = ((CreativeModeInventoryScreen)event.getGui()).getGuiLeft();
            this.guiCenterY = ((CreativeModeInventoryScreen)event.getGui()).getGuiTop();
            this.buttons = new ArrayList<WoodTypeButton>();
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, (Component)new TranslatableComponent("gui.nekoration.button.scroll_up"), button -> {
                if (startIndex > 0) {
                    --startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 64, 0);
            event.addWidget((GuiEventListener)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, (Component)new TranslatableComponent("gui.nekoration.button.scroll_down"), button -> {
                if (startIndex <= this.filters.size() - 4 - 1) {
                    ++startIndex;
                }
                this.updateTagButtons();
            }, ICONS, 80, 0);
            event.addWidget((GuiEventListener)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX + 32, this.guiCenterY - 50, (Component)new TranslatableComponent("gui.nekoration.button.enable_all"), button -> {
                this.filters.forEach(filters -> filters.setEnabled(true));
                this.buttons.forEach(WoodTypeButton::updateState);
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    this.updateItems((CreativeModeInventoryScreen)screen);
                }
            }, ICONS, 96, 0);
            event.addWidget((GuiEventListener)this.btnEnableAll);
            this.btnDisableAll = new IconButton(this.guiCenterX + 144, this.guiCenterY - 50, (Component)new TranslatableComponent("gui.nekoration.button.disable_all"), button -> {
                this.filters.forEach(filters -> filters.setEnabled(false));
                this.buttons.forEach(WoodTypeButton::updateState);
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CreativeModeInventoryScreen) {
                    this.updateItems((CreativeModeInventoryScreen)screen);
                }
            }, ICONS, 112, 0);
            event.addWidget((GuiEventListener)this.btnDisableAll);
            this.btnScrollUp.f_93624_ = false;
            this.btnScrollDown.f_93624_ = false;
            this.btnEnableAll.f_93624_ = false;
            this.btnDisableAll.f_93624_ = false;
            this.updateTagButtons();
            CreativeModeInventoryScreen screen = (CreativeModeInventoryScreen)event.getGui();
            if (screen.m_98628_() == ModItemTabs.WOODEN_GROUP.m_40775_()) {
                this.btnScrollUp.f_93624_ = true;
                this.btnScrollDown.f_93624_ = true;
                this.btnEnableAll.f_93624_ = true;
                this.btnDisableAll.f_93624_ = true;
                this.viewingFurnitureTab = true;
                this.buttons.forEach(button -> {
                    button.f_93624_ = true;
                });
                this.updateItems(screen);
            }
        }
    }

    @SubscribeEvent
    public void onScreenClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getButton() != 0) {
            return;
        }
        if (event.getGui() instanceof CreativeModeInventoryScreen) {
            for (Button button : this.buttons) {
                if (!button.m_5953_(event.getMouseX(), event.getMouseY()) || !button.m_6375_(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen = (CreativeModeInventoryScreen)event.getGui();
            if (screen.m_98628_() == ModItemTabs.WOODEN_GROUP.m_40775_()) {
                if (!this.viewingFurnitureTab) {
                    this.updateItems(screen);
                    this.viewingFurnitureTab = true;
                }
            } else {
                this.viewingFurnitureTab = false;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen = (CreativeModeInventoryScreen)event.getGui();
            this.guiCenterX = screen.getGuiLeft();
            this.guiCenterY = screen.getGuiTop();
            if (screen.m_98628_() == ModItemTabs.WOODEN_GROUP.m_40775_()) {
                this.btnScrollUp.f_93624_ = true;
                this.btnScrollDown.f_93624_ = true;
                this.btnEnableAll.f_93624_ = true;
                this.btnDisableAll.f_93624_ = true;
                this.buttons.forEach(button -> {
                    button.f_93624_ = true;
                });
                this.buttons.forEach(button -> button.m_6305_(event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()));
                this.buttons.forEach(button -> {
                    if (button.m_5953_(event.getMouseX(), event.getMouseY())) {
                        screen.m_96602_(event.getMatrixStack(), (Component)button.getCategory().getName(), event.getMouseX(), event.getMouseY());
                    }
                });
                if (this.btnEnableAll.m_5953_((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.m_96602_(event.getMatrixStack(), this.btnEnableAll.m_6035_(), event.getMouseX(), event.getMouseY());
                }
                if (this.btnDisableAll.m_5953_((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.m_96602_(event.getMatrixStack(), this.btnDisableAll.m_6035_(), event.getMouseX(), event.getMouseY());
                }
            } else {
                this.btnScrollUp.f_93624_ = false;
                this.btnScrollDown.f_93624_ = false;
                this.btnEnableAll.f_93624_ = false;
                this.btnDisableAll.f_93624_ = false;
                this.buttons.forEach(button -> {
                    button.f_93624_ = false;
                });
            }
        }
    }

    private void updateTagButtons() {
        Button.OnPress pressable = button -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                this.updateItems((CreativeModeInventoryScreen)screen);
            }
        };
        this.buttons.clear();
        for (int i = startIndex; i < startIndex + 4 && i < this.filters.size(); ++i) {
            WoodTypeButton button2 = new WoodTypeButton(this.guiCenterX - 28, this.guiCenterY + 29 * (i - startIndex) + 10, this.filters.get(i), pressable);
            this.buttons.add(button2);
        }
        this.btnScrollUp.f_93623_ = startIndex > 0;
        this.btnScrollDown.f_93623_ = startIndex <= this.filters.size() - 4 - 1;
    }

    private void updateItems(CreativeModeInventoryScreen screen) {
        CreativeModeInventoryScreen.ItemPickerMenu container = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
        NonNullList newItems = NonNullList.m_122779_();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_41471_() == ModItemTabs.WOODEN_GROUP).filter(item -> item.getRegistryName().m_135827_().equals("nekoration")).forEach(item -> {
            for (WoodFilter filter : this.filters) {
                if (!filter.isEnabled() || !(item instanceof HalfTimberBlockItem)) continue;
                ((HalfTimberBlockItem)((Object)item)).fillItemCategoryWithWoodType(ModItemTabs.WOODEN_GROUP, filter.getWood(), (NonNullList<ItemStack>)newItems);
            }
        });
        container.f_98639_.clear();
        container.f_98639_.addAll((Collection)newItems);
        container.f_98639_.sort(Comparator.comparingInt(o -> Item.m_41393_((Item)o.m_41720_())));
        container.m_98642_(0.0f);
    }

    private void compileItems() {
        WoodFilter OAK = new WoodFilter(NekoColors.EnumWoodenColor.LIGHT_GRAY, new ItemStack((ItemLike)Blocks.f_50705_));
        WoodFilter BIRCH = new WoodFilter(NekoColors.EnumWoodenColor.WHITE, new ItemStack((ItemLike)Blocks.f_50742_));
        WoodFilter ACACIA = new WoodFilter(NekoColors.EnumWoodenColor.ORANGE, new ItemStack((ItemLike)Blocks.f_50744_));
        WoodFilter JUNGLE = new WoodFilter(NekoColors.EnumWoodenColor.GRAY, new ItemStack((ItemLike)Blocks.f_50743_));
        WoodFilter SPRUCE = new WoodFilter(NekoColors.EnumWoodenColor.BROWN, new ItemStack((ItemLike)Blocks.f_50741_));
        WoodFilter WARPED = new WoodFilter(NekoColors.EnumWoodenColor.CYAN, new ItemStack((ItemLike)Blocks.f_50656_));
        WoodFilter CRIMSON = new WoodFilter(NekoColors.EnumWoodenColor.MAGENTA, new ItemStack((ItemLike)Blocks.f_50655_));
        WoodFilter DARK_OAK = new WoodFilter(NekoColors.EnumWoodenColor.BLACK, new ItemStack((ItemLike)Blocks.f_50745_));
        WoodFilter[] filters = new WoodFilter[]{OAK, BIRCH, ACACIA, JUNGLE, SPRUCE, WARPED, CRIMSON, DARK_OAK};
        this.filters = new ArrayList<WoodFilter>();
        this.filters.addAll(Arrays.asList(filters));
    }

    static {
        LOGGER = LogManager.getLogger((String)"Creative Tab");
    }

    public static class WoodFilter {
        private final NekoColors.EnumWoodenColor wood;
        private final TranslatableComponent name;
        private final ItemStack icon;
        private boolean enabled = true;

        public WoodFilter(NekoColors.EnumWoodenColor type, ItemStack icon) {
            this.wood = type;
            this.name = new TranslatableComponent(String.format("color.wooden.%s", type.m_7912_().replace("/", ".")));
            this.icon = icon;
        }

        public NekoColors.EnumWoodenColor getWood() {
            return this.wood;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public TranslatableComponent getName() {
            return this.name;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

