/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.gui.screen;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.entities.PaintingData;
import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.devbobcorn.nekoration.items.PaletteItem;
import com.devbobcorn.nekoration.network.C2SUpdatePaintingData;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class PaintingScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("nekoration", "textures/gui/painting.png");
    public static final int PAINTING_LEFT = 9;
    public static final int PAINTING_TOP = 38;
    public static final int PAINTING_WIDTH = 225;
    public static final int PAINTING_HEIGHT = 145;
    public static final int OPACITY_LEFT = 241;
    public static final int OPACITY_TOP = 38;
    public static final int OPACITY_WIDTH = 6;
    public static final int OPACITY_HEIGHT = 145;
    public static final int TOOLS_LEFT = 148;
    public static final int TOOLS_TOP = 13;
    public static final int TOOLS_NUM = 4;
    public static final int white = -1;
    public static final int black = -16777216;
    private final int imageWidth = 256;
    private final int imageHeight = 192;
    private int leftPos;
    private int topPos;
    private int entityId;
    private Color[] colors = new Color[6];
    private byte activeSlot = 0;
    private int opacity = 255;
    private int opacityPos = this.topPos + 38;
    private byte activeTool = 0;
    public boolean renderColorText = false;
    private final PaintingData paintingData;
    private final short paintingWidth;
    private final short paintingHeight;
    private final int oldHash;
    private double hor = 0.0;
    private double ver = 0.0;
    private int pixsize = 8;
    private TranslatableComponent tipMessage;
    private String debugText = "A nice line of debug text, isn't it?";
    private static final int radius = 2;

    public PaintingScreen(int pt) {
        this(pt, 0, PaletteItem.DEFAULT_COLOR_SET);
    }

    public PaintingScreen(int pt, byte active, Color[] paletteColors) {
        super(Component.m_130674_((String)"PAINTING"));
        this.activeSlot = active;
        this.colors = paletteColors;
        this.entityId = pt;
        PaintingEntity painting = (PaintingEntity)Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
        this.paintingData = painting.data;
        this.paintingWidth = painting.data.getWidth();
        this.paintingHeight = painting.data.getHeight();
        this.paintingData.imageReady = false;
        this.oldHash = this.paintingData.getPaintingHash();
        this.tipMessage = new TranslatableComponent("gui.nekoration.message.press_key_debug_info", new Object[]{"'E'"});
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void m_7379_() {
        try {
            if (this.oldHash != this.paintingData.getPaintingHash()) {
                this.paintingData.clearCache(this.oldHash);
                C2SUpdatePaintingData packet = new C2SUpdatePaintingData(this.entityId, this.paintingData.getPixels(), this.paintingData.getPaintingHash());
                ModPacketHandler.CHANNEL.sendToServer((Object)packet);
            } else {
                this.paintingData.imageReady = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 69) {
            this.renderColorText = !this.renderColorText;
            return true;
        }
        if (keyCode == 87) {
            this.activeTool = (byte)((this.activeTool + 1) % 4);
            return true;
        }
        if (keyCode == 65) {
            try {
                this.paintingData.save("paintings/canvas", String.valueOf(this.paintingData.getPaintingHash()), true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (keyCode == 83) {
            try {
                this.paintingData.save("paintings/content", String.valueOf(this.paintingData.getPaintingHash()), false, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (keyCode == 256) {
            Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_).m_6915_();
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    public void m_6305_(PoseStack stack, int x, int y, float partialTicks) {
        int i = this.leftPos;
        int j = this.topPos;
        super.m_6305_(stack, x, y, partialTicks);
        this.m_93179_(stack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        for (int idx = 0; idx < 6; ++idx) {
            RenderSystem.m_157429_((float)((float)this.colors[idx].getRed() / 255.0f), (float)((float)this.colors[idx].getGreen() / 255.0f), (float)((float)this.colors[idx].getBlue() / 255.0f), (float)1.0f);
            this.m_93228_(stack, i + 34 + 18 * idx, j + 13, 16, 224, 16, 16);
            if (idx != this.activeSlot) continue;
            this.m_93228_(stack, i + 8, j + 13, 16, 224, 16, 16);
        }
        try {
            for (short posi = 0; posi < this.paintingWidth; posi = (short)(posi + 1)) {
                if (this.hor + (double)((posi + 1) * this.pixsize) < 0.0 || this.hor + (double)(posi * this.pixsize) > 225.0) continue;
                for (short posj = 0; posj < this.paintingHeight; posj = (short)(posj + 1)) {
                    if (this.ver + (double)((posj + 1) * this.pixsize) < 0.0 || this.ver + (double)(posj * this.pixsize) > 145.0) continue;
                    Color color = NekoColors.getRGBColor(this.paintingData.getCompositeAt(posi, posj));
                    RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                    this.m_93228_(stack, i + 9 + (int)this.hor + posi * this.pixsize, j + 38 + (int)this.ver + posj * this.pixsize, 16, 224, this.pixsize, this.pixsize);
                }
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.renderBg(stack, partialTicks, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(stack, i + 34 + 18 * this.activeSlot, j + 13, 16, 208, 16, 16);
        this.m_93179_(stack, i + 241, j + 38, i + 241 + 6, j + 38 + 145, this.colors[this.activeSlot].getRGB(), this.colors[this.activeSlot].getRGB() & 0xFFFFFF);
        if (this.opacityPos >= 0) {
            this.m_93228_(stack, i + 241 - 1, this.opacityPos + this.topPos - 1, 0, 240, 8, 4);
        }
        this.m_93228_(stack, i + 148 + this.activeTool * 17, j + 13, 32 + this.activeTool * 16, 208, 16, 16);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        stack.m_85837_((double)(j + 5), (double)(-i - 265), 0.0);
        if (this.renderColorText) {
            this.f_96547_.m_92883_(stack, this.debugText, 1.0f, 1.0f, 0xFFFFFF);
        } else {
            this.f_96547_.m_92889_(stack, (Component)this.tipMessage, 1.0f, 1.0f, -1761607681);
        }
    }

    protected void renderBg(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(stack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean m_6375_(double x, double y, int type) {
        if (type == 0 && !this.updateActiveSlot(x, y)) {
            if (this.isOnOpacityPicker(x, y)) {
                this.getOpacity(x, y);
                this.debugText = "Opacity: " + this.opacity;
            } else if (this.isOnPainting(x, y)) {
                this.useTool(x, y);
            } else {
                for (int idx = 0; idx < 4; idx = (int)((byte)(idx + 1))) {
                    if (!this.isOn(x - 148.0 - (double)(idx * 17), y - 13.0, 16.0, 16.0)) continue;
                    this.activeTool = (byte)idx;
                }
            }
        }
        return super.m_6375_(x, y, type);
    }

    private boolean isOn(double x, double y, double w, double h) {
        double dx = x - (double)this.leftPos;
        double dy = y - (double)this.topPos;
        return dx >= 0.0 && dy >= 0.0 && dx <= w && dy <= h;
    }

    public boolean m_7979_(double x, double y, int type, double dx, double dy) {
        if (type == 0) {
            if (this.isOnPainting(x, y)) {
                this.useTool(x, y);
            } else if (this.isOnOpacityPicker(x, y)) {
                this.getOpacity(x, y);
                this.debugText = "Opacity: " + this.opacity;
            }
        } else if (type == 2) {
            this.hor += dx;
            this.ver += dy;
            this.debugText = "Position: " + x + ", " + y + " -> " + dx + ", " + dy;
        }
        return super.m_7979_(x, y, type, dx, dy);
    }

    private void useTool(double x, double y) {
        double areax = x - (double)this.leftPos - 9.0;
        double areay = y - (double)this.topPos - 38.0;
        double pixX = (areax - this.hor) / (double)this.pixsize;
        double pixY = (areay - this.ver) / (double)this.pixsize;
        switch (this.activeTool) {
            case 0: {
                this.debugText = String.format("Stroke: [%.2f, %.2f]", pixX, pixY);
                this.usePencil(pixX, pixY);
                break;
            }
            case 1: {
                this.debugText = String.format("Draw: [%.2f, %.2f]", pixX, pixY);
                this.usePen(pixX, pixY);
                break;
            }
            case 2: {
                this.debugText = String.format("Erase: [%.2f, %.2f]", pixX, pixY);
                this.useEraser(pixX, pixY);
                break;
            }
            case 3: {
                this.debugText = String.format("Fill: [%.2f, %.2f]", pixX, pixY);
            }
        }
    }

    private void usePencil(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        this.paintingData.setPixel(pixX, pixY, (this.opacity << 24) + this.colors[this.activeSlot].getRGB());
    }

    private void usePen(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        this.paintingData.setPixel(pixX, pixY, (this.opacity << 24) + this.colors[this.activeSlot].getRGB());
    }

    private void useEraser(double x, double y) {
        int pixX = (int)x;
        int pixY = (int)y;
        for (int i = -2; i < 2; ++i) {
            for (int j = -2; j < 2; ++j) {
                this.paintingData.setPixel(pixX + i, pixY + j, 0);
            }
        }
    }

    public boolean m_6050_(double x, double y, double d2) {
        this.debugText = "Scroll: " + x + ", " + y + ", " + d2;
        double areax = x - (double)this.leftPos - 9.0;
        double areay = y - (double)this.topPos - 38.0;
        double oldpixsize = this.pixsize;
        this.pixsize = (int)((double)this.pixsize + d2);
        this.pixsize = Math.min(Math.max(1, this.pixsize), 10);
        double scale = (double)this.pixsize / oldpixsize;
        double dx = (areax - this.hor) * scale;
        double dy = (areay - this.ver) * scale;
        this.hor = areax - dx;
        this.ver = areay - dy;
        return super.m_6050_(x, y, d2);
    }

    private boolean isOnPainting(double x, double y) {
        double dx = x - (double)this.leftPos - 9.0;
        double dy = y - (double)this.topPos - 38.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 225.0 && dy <= 145.0;
    }

    private boolean updateActiveSlot(double x, double y) {
        for (byte idx = 0; idx < 6; ++idx) {
            int l = this.leftPos + 34 + 18 * idx;
            int r = l + 16;
            int t = this.topPos + 13;
            int b = t + 16;
            if (!(x >= (double)l) || !(x <= (double)r) || !(y >= (double)t) || !(y <= (double)b) || this.activeSlot == idx) continue;
            this.activeSlot = idx;
            return true;
        }
        return false;
    }

    private boolean isOnOpacityPicker(double x, double y) {
        double dx = x - (double)this.leftPos - 241.0;
        double dy = y - (double)this.topPos - 38.0;
        return dx >= 0.0 && dy >= 0.0 && dx <= 6.0 && dy <= 145.0;
    }

    private void getOpacity(double x, double y) {
        this.opacity = (int)((1.0 - (y - (double)this.topPos - 38.0) / 145.0) * 255.0);
        this.opacityPos = (int)y - this.topPos;
    }

    public boolean m_7043_() {
        return false;
    }
}

