/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.gui.screen;

import com.devbobcorn.nekoration.network.C2SUpdatePaintingSize;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintingSizeScreen
extends Screen {
    public static final ResourceLocation PAINTING_SIZE = new ResourceLocation("nekoration", "textures/gui/painting_size.png");
    public static final int BACKGROUND_WIDTH = 124;
    public static final int BACKGROUND_HEIGHT = 146;
    public static final int GRID_LEFT = 8;
    public static final int GRID_TOP = 30;
    public static final int SLOT_LEN = 18;
    private int leftPos;
    private int topPos;
    private InteractionHand hand;
    private short pickedWidth;
    private short pickedHeight;

    public PaintingSizeScreen(InteractionHand hand) {
        super(Component.m_130674_((String)"PAINTING_SIZE"));
        this.hand = hand;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.pickedWidth = (short)3;
        this.pickedHeight = (short)3;
        this.leftPos = (this.f_96543_ - 124) / 2;
        this.topPos = (this.f_96544_ - 146) / 2;
    }

    public void m_6305_(PoseStack stack, int x, int y, float partialTicks) {
        stack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PAINTING_SIZE);
        int i = this.leftPos;
        int j = this.topPos;
        this.m_93228_(stack, i, j, 0, 0, 124, 146);
        stack.m_85849_();
        super.m_6305_(stack, x, y, partialTicks);
        for (short ix = 0; ix < 6; ++ix) {
            for (int iy = 0; iy < 6; ++iy) {
                this.m_93228_(stack, i + 8 + ix * 18, j + 30 + iy * 18, ix < this.pickedWidth && iy < this.pickedHeight ? 18 : 0, 160, 18, 18);
            }
        }
        PaintingSizeScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)("Size:  " + this.pickedWidth + "x" + this.pickedHeight), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 66), (int)-1);
    }

    public void m_94757_(double x, double y) {
        double gridx = x - (double)this.leftPos - 8.0;
        double gridy = y - (double)this.topPos - 30.0;
        if (gridx < 0.0 || gridy < 0.0 || gridx > 108.0 || gridy > 108.0) {
            return;
        }
        this.pickedWidth = (short)Math.min(Math.max((int)Math.ceil(gridx / 18.0), 1), 6);
        this.pickedHeight = (short)Math.min(Math.max((int)Math.ceil(gridy / 18.0), 1), 6);
    }

    public boolean m_6375_(double x, double y, int type) {
        double gridx = x - (double)this.leftPos - 8.0;
        double gridy = y - (double)this.topPos - 30.0;
        if (gridx < 0.0 || gridy < 0.0 || gridx > 108.0 || gridy > 108.0) {
            return false;
        }
        this.pickedWidth = (short)Math.min(Math.max((int)Math.ceil(gridx / 18.0), 1), 6);
        this.pickedHeight = (short)Math.min(Math.max((int)Math.ceil(gridy / 18.0), 1), 6);
        C2SUpdatePaintingSize packet = new C2SUpdatePaintingSize(this.hand, this.pickedWidth, this.pickedHeight);
        ModPacketHandler.CHANNEL.sendToServer((Object)packet);
        this.f_96541_.m_91152_((Screen)null);
        return true;
    }

    public boolean m_7933_(int i1, int i2, int i3) {
        return super.m_7933_(i1, i2, i3);
    }

    public boolean m_7043_() {
        return false;
    }
}

