/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class QuadRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("nekoration:textures/block/custom.png");

    public static void renderCubeUsingQuads(BlockEntity tileEntity, float partialTicks, PoseStack stack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Color color = Color.WHITE;
        QuadRenderer.drawCubeQuads(stack, buffers, color, combinedLight);
    }

    private static void drawCubeQuads(PoseStack stack, MultiBufferSource buffers, Color color, int combinedLight) {
        VertexConsumer vertexBuilderBlockQuads = buffers.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE));
        Matrix4f matrixPos = stack.m_85850_().m_85861_();
        Matrix3f matrixNormal = stack.m_85850_().m_85864_();
        Vec2 bottomLeftUV = new Vec2(0.0f, 1.0f);
        float UVwidth = 1.0f;
        float UVheight = 1.0f;
        float WIDTH = 1.0f;
        float HEIGHT = 1.0f;
        Vector3d EAST_FACE_MIDPOINT = new Vector3d(1.0, 0.5, 0.5);
        Vector3d WEST_FACE_MIDPOINT = new Vector3d(0.0, 0.5, 0.5);
        Vector3d NORTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 0.0);
        Vector3d SOUTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 1.0);
        Vector3d UP_FACE_MIDPOINT = new Vector3d(0.5, 1.0, 0.5);
        Vector3d DOWN_FACE_MIDPOINT = new Vector3d(0.5, 0.0, 0.5);
        QuadRenderer.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        QuadRenderer.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
    }

    private static void addFace(Direction whichFace, Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer buffers, Color color, Vector3d centrePos, float width, float height, Vec2 bottomLeftUV, float texUwidth, float texVheight, int lightmapValue) {
        Vec3 leftToRightDirection;
        Vec3 bottomToTopDirection = switch (whichFace) {
            case Direction.NORTH -> {
                leftToRightDirection = new Vec3(-1.0, 0.0, 0.0);
                yield new Vec3(0.0, 1.0, 0.0);
            }
            case Direction.SOUTH -> {
                leftToRightDirection = new Vec3(1.0, 0.0, 0.0);
                yield new Vec3(0.0, 1.0, 0.0);
            }
            case Direction.EAST -> {
                leftToRightDirection = new Vec3(0.0, 0.0, -1.0);
                yield new Vec3(0.0, 1.0, 0.0);
            }
            case Direction.WEST -> {
                leftToRightDirection = new Vec3(0.0, 0.0, 1.0);
                yield new Vec3(0.0, 1.0, 0.0);
            }
            case Direction.UP -> {
                leftToRightDirection = new Vec3(-1.0, 0.0, 0.0);
                yield new Vec3(0.0, 0.0, 1.0);
            }
            case Direction.DOWN -> {
                leftToRightDirection = new Vec3(1.0, 0.0, 0.0);
                yield new Vec3(0.0, 0.0, 1.0);
            }
            default -> {
                leftToRightDirection = new Vec3(0.0, 0.0, 1.0);
                yield new Vec3(0.0, 1.0, 0.0);
            }
        };
        leftToRightDirection.m_82490_((double)(0.5f * width));
        bottomToTopDirection.m_82490_((double)(0.5f * height));
        Vec3 bottomLeftPos = new Vec3(centrePos.f_86214_, centrePos.f_86215_, centrePos.f_86216_);
        bottomLeftPos.m_82546_(leftToRightDirection);
        bottomLeftPos.m_82546_(bottomToTopDirection);
        Vec3 bottomRightPos = new Vec3(centrePos.f_86214_, centrePos.f_86215_, centrePos.f_86216_);
        bottomRightPos.m_82549_(leftToRightDirection);
        bottomRightPos.m_82546_(bottomToTopDirection);
        Vec3 topRightPos = new Vec3(centrePos.f_86214_, centrePos.f_86215_, centrePos.f_86216_);
        topRightPos.m_82549_(leftToRightDirection);
        topRightPos.m_82549_(bottomToTopDirection);
        Vec3 topLeftPos = new Vec3(centrePos.f_86214_, centrePos.f_86215_, centrePos.f_86216_);
        topLeftPos.m_82546_(leftToRightDirection);
        topLeftPos.m_82549_(bottomToTopDirection);
        Vec2 bottomLeftUVpos = new Vec2(bottomLeftUV.f_82470_, bottomLeftUV.f_82471_);
        Vec2 bottomRightUVpos = new Vec2(bottomLeftUV.f_82470_ + texUwidth, bottomLeftUV.f_82471_);
        Vec2 topLeftUVpos = new Vec2(bottomLeftUV.f_82470_ + texUwidth, bottomLeftUV.f_82471_ + texVheight);
        Vec2 topRightUVpos = new Vec2(bottomLeftUV.f_82470_, bottomLeftUV.f_82471_ + texVheight);
        Vector3f normalVector = whichFace.m_122432_();
        QuadRenderer.addQuad(matrixPos, matrixNormal, buffers, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightmapValue);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer buffers, Vec3 blpos, Vec3 brpos, Vec3 trpos, Vec3 tlpos, Vec2 blUVpos, Vec2 brUVpos, Vec2 trUVpos, Vec2 tlUVpos, Vector3f normalVector, Color color, int lightmapValue) {
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, blpos, blUVpos, normalVector, color, lightmapValue);
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, brpos, brUVpos, normalVector, color, lightmapValue);
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, trpos, trUVpos, normalVector, color, lightmapValue);
        QuadRenderer.addQuadVertex(matrixPos, matrixNormal, buffers, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    private static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer buffers, Vec3 pos, Vec2 texUV, Vector3f normalVector, Color color, int lightmapValue) {
        buffers.m_5483_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(texUV.f_82470_, texUV.f_82471_).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmapValue).m_5601_(normalVector.m_122239_(), normalVector.m_122260_(), normalVector.m_122269_()).m_5752_();
    }
}

