/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.items;

import com.devbobcorn.nekoration.NekoColors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DyeableBlockItem
extends BlockItem {
    public static final String COLOR = "color";
    private final boolean showAllVariants;

    public DyeableBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
        this.showAllVariants = true;
    }

    public DyeableBlockItem(Block block, Item.Properties settings, boolean allVariants) {
        super(block, settings);
        this.showAllVariants = allVariants;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            if (this.showAllVariants) {
                for (NekoColors.EnumNekoColor color : NekoColors.EnumNekoColor.values()) {
                    ItemStack subItemStack = new ItemStack((ItemLike)this, 1);
                    DyeableBlockItem.setColor(subItemStack, color);
                    subItems.add((Object)subItemStack);
                }
            } else {
                ItemStack subItemStack = new ItemStack((ItemLike)this, 1);
                DyeableBlockItem.setColor(subItemStack, NekoColors.EnumNekoColor.WHITE);
                subItems.add((Object)subItemStack);
            }
        }
    }

    public static NekoColors.EnumNekoColor getColor(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41784_();
        return NekoColors.EnumNekoColor.fromNBT(compoundNBT, COLOR);
    }

    public static void setColor(ItemStack stack, NekoColors.EnumNekoColor color) {
        CompoundTag compoundNBT = stack.m_41784_();
        color.putIntoNBT(compoundNBT, COLOR);
    }

    public static float getColorPropertyOverride(ItemStack itemStack, @Nullable Level world, @Nullable LivingEntity livingEntity, int what) {
        NekoColors.EnumNekoColor color = DyeableBlockItem.getColor(itemStack);
        return color.getPropertyOverrideValue();
    }

    public Component m_7626_(ItemStack stack) {
        String colorText = new TranslatableComponent("color.nekoration." + DyeableBlockItem.getColor(stack).m_7912_()).getString();
        return new TranslatableComponent(this.m_5671_(stack), new Object[]{colorText});
    }
}

