/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.entities.PaintingEntity;
import com.devbobcorn.nekoration.network.ModPacketHandler;
import com.devbobcorn.nekoration.network.S2CUpdatePaintingData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class C2SUpdatePaintingData {
    public int paintingId;
    public int[] pixels;
    public int compositeHash;

    public C2SUpdatePaintingData(int id, int[] pixels, int hash) {
        this.paintingId = id;
        this.pixels = pixels;
        this.compositeHash = hash;
    }

    public static void encode(C2SUpdatePaintingData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.paintingId);
        packetBuffer.m_130089_(msg.pixels);
        packetBuffer.writeInt(msg.compositeHash);
    }

    public static C2SUpdatePaintingData decode(FriendlyByteBuf packetBuffer) {
        int i = packetBuffer.readInt();
        int[] p = packetBuffer.m_130100_();
        int hash = packetBuffer.readInt();
        return new C2SUpdatePaintingData(i, p, hash);
    }

    public static void handle(C2SUpdatePaintingData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(msg.paintingId)) instanceof PaintingEntity) {
                ((PaintingEntity)entity).data.setPixels(msg.pixels);
                System.out.println("Painting Updated!");
                S2CUpdatePaintingData packet = new S2CUpdatePaintingData(msg.paintingId, msg.pixels, msg.compositeHash);
                ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

