/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.items.ModItems;
import com.devbobcorn.nekoration.items.PaintingItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class C2SUpdatePaintingSize {
    public InteractionHand hand;
    public short width;
    public short height;

    public C2SUpdatePaintingSize(InteractionHand hand, short w, short h) {
        this.hand = hand;
        this.width = w;
        this.height = h;
    }

    public static void encode(C2SUpdatePaintingSize msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)msg.hand);
        packetBuffer.writeShort((int)msg.width);
        packetBuffer.writeShort((int)msg.height);
    }

    public static C2SUpdatePaintingSize decode(FriendlyByteBuf packetBuffer) {
        InteractionHand hand = (InteractionHand)packetBuffer.m_130066_(InteractionHand.class);
        short w = packetBuffer.readShort();
        short h = packetBuffer.readShort();
        return new C2SUpdatePaintingSize(hand, w, h);
    }

    public static void handle(C2SUpdatePaintingSize msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null) {
                ItemStack updated = new ItemStack((ItemLike)ModItems.PAINTING.get());
                PaintingItem.setWidth(updated, msg.width);
                PaintingItem.setHeight(updated, msg.height);
                player.m_21008_(msg.hand, updated);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

