/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.items.ModItems;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class C2SUpdatePaletteData {
    public InteractionHand hand = null;
    public byte active = 0;
    public int[] colors = new int[6];

    public C2SUpdatePaletteData(InteractionHand hand, byte slot, int[] colors) {
        this.hand = hand;
        this.active = slot;
        this.colors = colors;
    }

    public static void encode(C2SUpdatePaletteData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)msg.hand);
        packetBuffer.writeByte((int)msg.active);
        packetBuffer.m_130089_(msg.colors);
    }

    public static C2SUpdatePaletteData decode(FriendlyByteBuf packetBuffer) {
        InteractionHand h = (InteractionHand)packetBuffer.m_130066_(InteractionHand.class);
        byte a = packetBuffer.readByte();
        int[] c = packetBuffer.m_130100_();
        return new C2SUpdatePaletteData(h, a, c);
    }

    public static void handle(C2SUpdatePaletteData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player != null) {
                ItemStack updated = new ItemStack((ItemLike)ModItems.PALETTE.get());
                CompoundTag nbt = updated.m_41784_();
                nbt.m_128344_("active", msg.active);
                nbt.m_128385_("colors", msg.colors);
                updated.m_41751_(nbt);
                player.m_21008_(msg.hand, updated);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

