/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.network;

import com.devbobcorn.nekoration.blocks.entities.EaselMenuBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class S2CUpdateEaselMenuData {
    public ItemStack[] items = new ItemStack[8];
    public BlockPos pos = BlockPos.f_121853_;
    public Component[] texts = new Component[8];
    public DyeColor[] colors = new DyeColor[8];
    public boolean glow;

    public S2CUpdateEaselMenuData(BlockPos pos, ItemStack[] items, Component[] texts, DyeColor[] colors, boolean glowing) {
        this.pos = pos;
        this.items = items;
        this.texts = texts;
        this.colors = colors;
        this.glow = glowing;
    }

    public static void encode(S2CUpdateEaselMenuData msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(msg.pos);
        for (int i = 0; i < 8; ++i) {
            packetBuffer.writeItemStack(msg.items[i], false);
            packetBuffer.m_130083_(msg.texts[i]);
            packetBuffer.m_130068_((Enum)msg.colors[i]);
        }
        packetBuffer.writeBoolean(msg.glow);
    }

    public static S2CUpdateEaselMenuData decode(FriendlyByteBuf packetBuffer) {
        BlockPos pos = packetBuffer.m_130135_();
        ItemStack[] t = new ItemStack[8];
        Component[] x = new Component[8];
        DyeColor[] c = new DyeColor[8];
        for (int i = 0; i < 8; ++i) {
            t[i] = packetBuffer.m_130267_();
            x[i] = packetBuffer.m_130238_();
            c[i] = (DyeColor)packetBuffer.m_130066_(DyeColor.class);
        }
        return new S2CUpdateEaselMenuData(pos, t, x, c, packetBuffer.readBoolean());
    }

    public static void handle(S2CUpdateEaselMenuData msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockEntity tileEntity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world.m_46749_(msg.pos) && (tileEntity = world.m_7702_(msg.pos)) instanceof EaselMenuBlockEntity) {
                EaselMenuBlockEntity te = (EaselMenuBlockEntity)tileEntity;
                for (int i = 0; i < 8; ++i) {
                    te.renderItems[i] = msg.items[i];
                    te.setMessage(i, msg.texts[i]);
                }
                te.setColors(msg.colors);
                te.setGlowing(msg.glow);
                tileEntity.m_6596_();
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

